% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgvar.R
\name{coef.bgvar}
\alias{coef.bgvar}
\alias{coefficients.bgvar}
\title{Extract model coefficients}
\usage{
\method{coef}{bgvar}(object, ..., quantile = 0.5)

\method{coefficients}{bgvar}(object, ..., quantile = 0.5)
}
\arguments{
\item{object}{an object of class \code{bgvar}.}

\item{...}{additional arguments.}

\item{quantile}{reported quantiles. Default is set to the median.}
}
\value{
Returns an \code{q} times \code{K} times \code{K} times \code{p} array of the global coefficients, where \code{q} is the number of specified quantiles (this dimension is dropped if \code{q=1}), \code{K} the number of endogenous variables and \code{p} number of lags.
}
\description{
Extracts the global model coefficients for \code{bgvar} for certain quantiles of the posterior distribution. \code{coefficients} is an \emph{alias} for it.
}
\examples{
\donttest{
library(BGVAR)
data(eerData)
model.ng <- bgvar(Data=eerData,W=W.trade0012,plag=1,draws=100,burnin=100)
coef(model.ng)
}
\donttest{
coefficients(model.ng)
}
}
