% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CuMRes.R
\name{CuMRes}
\alias{CuMRes}
\title{Bayesian Semiparametric Cure Rate Model with an Unknown Threshold}
\usage{
CuMRes(times, delta = rep(1, length(times)), type.t = 3,
  length = NULL, K = 50, alpha = rep(0.01, K), beta = rep(0.01, K),
  c.r = rep(1, (K - 1)), type.c = 4, epsilon = 1, c.nu = 1,
  a.eps = 0.1, b.eps = 0.1, a.mu = 0.01, b.mu = 0.01,
  iterations = 1000, burn.in = floor(iterations * 0.2), thinning = 5,
  printtime = TRUE)
}
\arguments{
\item{times}{Numeric positive vector. Failure times.}

\item{delta}{Logical vector. Status indicator. \code{TRUE} (1) indicates
exact lifetime is known, \code{FALSE} (0) indicates that the corresponding
failure time is right censored.}

\item{type.t}{Integer. 1=computes uniformly-dense intervals; 2=length
intervals defined by the user and 3=same length intervals.}

\item{length}{Integer. Interval length for the partition.}

\item{K}{Integer. Partition length for the hazard function if
\code{type.t}=1 or \code{type.t}=3.}

\item{alpha}{Nonnegative entry vector. Small entries are recommended in
order to specify a non-informative prior distribution.}

\item{beta}{Nonnegative entry vector. Small entries are recommended in order
to specify a non-informative prior distribution.}

\item{c.r}{Nonnegative vector. The higher the entries, the higher the correlation of two consecutive intervals.}

\item{type.c}{1=defines \code{c.r} as a zero-entry vector; 2=lets the user
define \code{c.r} freely; 3=assigns \code{c.r} by computing an exponential
prior distribution with mean 1; 4=assigns \code{c.r} by computing an exponential hierarchical
distribution with mean \code{epsilon} which in turn has a Ga(a.eps, b.eps)
distribution.}

\item{epsilon}{Double. Mean of the exponential distribution assigned to
\code{c.r} when \code{type.c = 3}. When \code{type.c = 4}, \code{epsilon} is
assigned a Ga(a.eps,b.eps) distribution.}

\item{c.nu}{Tuning parameter for the proposal distribution for c.}

\item{a.eps}{Numeric. Shape parameter for the prior gamma distribution of
epsilon when \code{type.c = 4}.}

\item{b.eps}{Numeric. Scale parameter for the prior gamma distribution of
epsilon when \code{type.c = 4}.}

\item{a.mu}{Numeric. Shape parameter for the prior gamma distribution of
mu}

\item{b.mu}{Numeric. Scale parameter for the prior gamma distribution of
mu}

\item{iterations}{Integer. Number of iterations including the \code{burn.in}
to be computed for the Markov Chain.}

\item{burn.in}{Integer. Length of the burn-in period for the Markov chain.}

\item{thinning}{Integer. Factor by which the chain will be thinned. Thinning
the Markov chain is to reduces autocorrelation.}

\item{printtime}{Logical. If \code{TRUE}, prints out the execution time.}
}
\description{
Posterior inference for the bayesian semiparametric cure rate model in
survival analysis.
}
\details{
Computes the Gibbs sampler with the full conditional distributions of
all model parameters (Nieto-Barajas & Yin 2008) and arranges the resulting Markov
chain into a tibble which can be used to obtain posterior summaries.
}
\note{
It is recommended to verify chain's stationarity. This can be done by
checking each element individually. See \code{\link{CuPlotDiag}}.
}
\examples{


## Simulations may be time intensive. Be patient.
## Example 1
# data(crm3)
# times<-crm3$times
# delta<-crm3$delta
# res <- CuMRes(times, delta, type.t = 2, 
#                   K = 100, length = .1, alpha = rep(1, 100  ), 
#                   beta = rep(1, 100),c.r = rep(50, 99), 
#                   iterations = 100, burn.in = 10, thinning = 1, type.c = 2)


}
