% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_adj_mat.R
\name{weighted_adj_mat}
\alias{weighted_adj_mat}
\title{Extract the Weighted Adjacency Matrix}
\usage{
weighted_adj_mat(object, ...)
}
\arguments{
\item{object}{A model estimated with \strong{BGGM}. All classes are supported, assuming
there is matrix to be extracted.}

\item{...}{Currently ignored.}
}
\value{
The weighted adjacency matrix (partial correlation matrix with zeros).
}
\description{
Extract the weighted adjacency matrix (posterior mean) from
\code{\link{estimate}}, \code{\link{explore}}, \code{\link{ggm_compare_estimate}},
and \code{\link{ggm_compare_explore}} objects.
}
\examples{
\donttest{
# note: iter = 250 for demonstrative purposes
Y <- bfi[,1:5]

# estimate
fit <- estimate(Y, iter = 250,
                progress = FALSE)

# select graph
E <- select(fit)

# extract weighted adj matrix
weighted_adj_mat(E)

}
}
