% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bekk_spec.R
\name{bekk_spec}
\alias{bekk_spec}
\title{BEKK specification method}
\usage{
bekk_spec(
  model = list(type = "bekk", asymmetric = FALSE),
  init_values = NULL,
  signs = NULL,
  N = NULL,
  compare = FALSE
)
}
\arguments{
\item{model}{A list containing the model type specification: Either "bekk" "dbekk" or "sbekk".
Moreover it can be specified whether the model should be estimated allowing for asymmetric volatility structure.}

\item{init_values}{initial values for \link{bekk_fit} during BHHH algorithm. It can be either a numerical vector of suitable dimension, or a character vector i.e. "random" to use a random starting value generator (set a seed in advance for reproducible results), or
"simple" for relying on a simple initial values generator based on typical values for BEKK parameter found in the literature. If the object from this function is passed to \link{bekk_sim}, "init_values" are used as parameters for data generating process.}

\item{signs}{An N-dimensional vector consisting of "1" or "-1" to indicate the asymmetric effects to be considered.
Setting the i-th element of the vector to "1" or "-1" means that the model takes into account additional volatility if the returns of the i-th column in the data matrix are either positive or negative.
If "asymmetric = TRUE", the default is set to "rep(-1, N)" i.e. it is assumed that excess volatility occurs for all series if the returns are negative.}

\item{N}{Integer specifying the dimension of the BEKK model. Only relevant for \link{bekk_sim}.}

\item{compare}{Boolean specifying if the outcome of an asymmetric model is compared to its symmetric estimation result.}
}
\value{
Returns a S3 class "bekkSpec"  object containing the specifications of the model to be estimated.
}
\description{
Method for creating a N-dimensional BEKK model specification object prior to fitting and/or simulating.
}
