% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchId.R
\name{searchId}
\alias{searchId}
\title{Search identifier, symbol or name information}
\usage{
searchId(
  searched,
  be = NULL,
  organism = NULL,
  ncharSymb = 4,
  ncharName = 8,
  verbose = FALSE
)
}
\arguments{
\item{searched}{the searched term. Identifiers are searched by exact match.
Symbols and names are also searched for partial match when searched is
greater than ncharSymb and ncharName respectively.}

\item{be}{optional. If provided the search is focused on provided BEs.}

\item{organism}{optional.  If provided the search is focused on provided
organisms.}

\item{ncharSymb}{The minimum number of characters in searched to consider
incomplete symbol matches.}

\item{ncharName}{The minimum number of characters in searched to consider
incomplete name matches.}

\item{verbose}{boolean indicating if the CQL queries should be displayed}
}
\value{
A data frame with the following fields:
\itemize{
\item \strong{found}: the element found in BED corresponding to the searched term
\item \strong{be}: the type of the element
\item \strong{source}: the source of the element
\item \strong{organism}: the related organism
\item \strong{entity}: the related entity internal ID
\item \strong{ebe}: the BE of the related entity
\item \strong{canonical}: if the symbol is canonical
\item \strong{gene}: list of the related genes BE internal ID
}

Exact matches are returned first folowed by the shortest elements.
}
\description{
\strong{DEPRECATED: use \link{searchBeid} and \link{geneIDsToAllScopes} instead.}
This function is meant to be used with \link{getRelevantIds} in order
to implement a dictonary of identifiers of interest. First
the \link{searchId} function is used to search a term.
Then the \link{getRelevantIds} function
is used to find the corresponding ID in a context of interest.
}
\seealso{
\link{getRelevantIds}
}
