% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRelevantIds.R
\name{getRelevantIds}
\alias{getRelevantIds}
\title{Get relevant IDs for a formerly identified BE in a context of interest}
\usage{
getRelevantIds(
  d,
  selected = 1,
  be = c(listBe(), "Probe"),
  source,
  organism,
  restricted = TRUE,
  simplify = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{d}{the data.frame returned by \link{searchId}.}

\item{selected}{the rows of interest in d}

\item{be}{the BE in the context of interest}

\item{source}{the source of the identifier in the context of interest}

\item{organism}{the organism in the context of interest}

\item{restricted}{boolean indicating if the results should be restricted to
current version of to BEID db. If FALSE former BEID are also returned:
\strong{Depending on history it can take a very long time to return}
\strong{a very large result!}}

\item{simplify}{if TRUE (default) duplicated IDs are removed from the output}

\item{verbose}{if TRUE, the CQL query is shown}
}
\value{
The d data.frame with a new column providing the relevant ID
in the context of interest and without the gene field.
Scope ("be", "source" and "organism") is provided as a named list
in the "scope" attributes: \code{attr(x, "scope")}
}
\description{
\strong{DEPRECATED: use \link{searchBeid} and \link{geneIDsToAllScopes} instead.}
This function is meant to be used with \link{searchId} in order
to implement a dictonary of identifiers of interest. First
the \link{searchId} function is used to search a term.
Then the \link{getRelevantIds} function
is used to find the corresponding IDs in a context of interest.
}
\seealso{
\link{searchId}
}
