% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bcdagCE.R
\name{plot.bcdagCE}
\alias{plot.bcdagCE}
\title{bcdagCE object plot}
\usage{
\method{plot}{bcdagCE}(x, ..., which_ce = integer(0))
}
\arguments{
\item{x}{a \code{bcdagCE} object for which a plot is desired}

\item{...}{additional arguments affecting the summary produced}

\item{which_ce}{specifies the list of nodes for which you intend to generate a boxplot and a histogram}
}
\value{
Boxplot and histogram of the posterior distribution of the causal effects computed using get_causaleffect().
}
\description{
This method returns summary plots of the output of \code{get_causaleffect()}.
}
\examples{
q = 8
w = 0.2
set.seed(123)
DAG = rDAG(q = q, w = w)
outDL = rDAGWishart(n = 1, DAG = DAG, a = q, U = diag(1, q))
L = outDL$L; D = outDL$D
Sigma = solve(t(L))\%*\%D\%*\%solve(L)
n = 200
# Generate observations from a Gaussian DAG-model
X = mvtnorm::rmvnorm(n = n, sigma = Sigma)
# Run the MCMC (set S = 5000 and burn = 1000 for better results)
out_mcmc = learn_DAG(S = 500, burn = 100, a = q, U = diag(1,q)/n, data = X, w = w,
                     fast = TRUE, save.memory = FALSE, verbose = FALSE)
out_ce <- get_causaleffect(out_mcmc, targets = c(4,6), response = 1)
plot(out_ce)
}
