% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.bcdagCE.R
\name{confint.bcdagCE}
\alias{confint.bcdagCE}
\title{Credible Intervals for bcdagCE Object}
\usage{
\method{confint}{bcdagCE}(object, parm = "all", level = 0.95, ...)
}
\arguments{
\item{object}{a \code{bcdagCE} object from which credible intervals are computed.}

\item{parm}{an integer vector indexing the target variables for which credible intervals are computed. If missing, all variables are considered.}

\item{level}{the credible level required.}

\item{...}{additional arguments.}
}
\value{
A matrix with columns giving lower and upper credible limits for each variable.
}
\description{
Computes credible (not confidence!) intervals for one or more target variables from objects of class \code{bcdagCE}.
}
\examples{
q = 8
w = 0.2
set.seed(123)
DAG = rDAG(q = q, w = w)
outDL = rDAGWishart(n = 1, DAG = DAG, a = q, U = diag(1, q))
L = outDL$L; D = outDL$D
Sigma = solve(t(L))\%*\%D\%*\%solve(L)
n = 200
# Generate observations from a Gaussian DAG-model
X = mvtnorm::rmvnorm(n = n, sigma = Sigma)
# Run the MCMC (set S = 5000 and burn = 1000 for better results)
out_mcmc = learn_DAG(S = 500, burn = 100, a = q, U = diag(1,q)/n, data = X, w = w,
                     fast = TRUE, save.memory = FALSE, verbose = FALSE)
out_ce <- get_causaleffect(out_mcmc, targets = c(4,6), response = 1)
confint(out_ce, c(4,6), 0.95)
}
