BANOVA.NormalNormal <-
function(l1_formula = 'NA', l2_formula = 'NA', data, id, burnin = 1000, sample = 1000, thin = 2, jags){
  cat('Model initializing...\n')
  # check each column in the dataframe should have the class 'factor' or 'numeric', no other classes such as 'matrix'...
  for (i in 1:ncol(data))
    if(class(data[,i]) != 'factor' && class(data[,i]) != 'numeric' && class(data[,i]) != 'integer') stop("data class must be 'factor', 'numeric' or 'integer'")
  mf1 <- model.frame(formula = l1_formula, data = data)
  mf2 <- model.frame(formula = l2_formula, data = data)
  n <- nrow(data)
  uni_id <- unique(id)
  num_id <- length(uni_id)
  new_id <- rep(0, length(id)) # store the new id from 1,2,3,...
  for (i in 1:length(id))
    new_id[i] <- which(uni_id == id[i])
  id <- new_id
  dMatrice <- design.matrix(l1_formula, l2_formula, data = data, id = id)
  JAGS.model <- JAGSgen.normalNormal(dMatrice$X, dMatrice$Z)
  JAGS.data <- dump.format(list(n = n, id = id, M = num_id, y = dMatrice$y, X = dMatrice$X, Z = dMatrice$Z))
  result <- run.jags (model = JAGS.model$sModel, data = JAGS.data, inits = JAGS.model$inits, n.chains = 1,
                      monitor = c(JAGS.model$monitorl1.parameters, JAGS.model$monitorl2.parameters), 
                      burnin = burnin, sample = sample, thin = thin, adapt = 0, jags = jags, summarise = FALSE, 
                      check.stochastic = FALSE, method="rjags")
  samples <- result$mcmc[[1]]
  # find the correct samples, in case the order of monitors is shuffled by JAGS
  n_p_l2 <- length(JAGS.model$monitorl2.parameters)
  index_l2_param<- array(0,dim = c(n_p_l2,1))
  for (i in 1:n_p_l2)
    index_l2_param[i] <- which(colnames(result$mcmc[[1]]) == JAGS.model$monitorl2.parameters[i])
  if (length(index_l2_param) > 1)
    samples_l2_param <- result$mcmc[[1]][,index_l2_param]
  else
    samples_l2_param <- matrix(result$mcmc[[1]][,index_l2_param], ncol = 1)
  n_p_l1 <- length(JAGS.model$monitorl1.parameters)
  index_l1_param<- array(0,dim = c(n_p_l1,1))
  for (i in 1:n_p_l1)
    index_l1_param[i] <- which(colnames(result$mcmc[[1]]) == JAGS.model$monitorl1.parameters[i])
  if (length(index_l1_param) > 1)
    samples_l1_param <- result$mcmc[[1]][,index_l1_param]
  else
    samples_l1_param <- matrix(result$mcmc[[1]][,index_l1_param], ncol = 1)
  
  #anova.table <- table.ANOVA(samples_l1_param, dMatrice$X, dMatrice$Z)
  cat('Constructing ANOVA/ANCOVA tables...\n')
  anova.table <- table.ANCOVA(samples_l1_param, dMatrice$X, dMatrice$Z) # for ancova models
  coef.tables <- table.coefficients(samples_l2_param, JAGS.model$monitorl2.parameters, colnames(dMatrice$X), colnames(dMatrice$Z), 
                                    attr(dMatrice$X, 'assign') + 1, attr(dMatrice$Z, 'assign') + 1)
  pvalue.table <- table.pvalue(coef.tables$coeff_table, coef.tables$row_indices, l1_names = attr(dMatrice$X, 'varNames'), 
                               l2_names = attr(dMatrice$Z, 'varNames'))
  return(list(anova.table = anova.table,
              coef.tables = coef.tables,
              pvalue.table = pvalue.table, dMatrice = dMatrice, samples_l2_param = samples_l2_param, data = data, mf1 = mf1, mf2 = mf2, JAGSmodel = JAGS.model$sModel))
}
