% Generated by roxygen2 (4.0.0): do not edit by hand
\name{DPM.HODC}
\alias{DPM.HODC}
\title{Hierarchical Ordered Density Clustering (HODC) for Dirichlet Process Mixture Model Fitting}
\description{
This function implements the HODC algorithm for posterior density samples by a Dirichlet process mixture (DPM) of normals model which is implemented by function "DPdensity" in R package \strong{DPpackages}.  
}

\usage{
DPM.HODC(v, pvalue,
DPM.mcmc=list(nburn=2000,nsave=1,
nskip=0,ndisplay=10),
DPM.prior=list(a0=2,b0=1,m2=rep(0,1),
s2=diag(100000,1),
psiinv2=solve(diag(0.5,1)),
nu1=4,nu2=4,tau1=1,tau2=100))
}
\arguments{
\item{pvalue}{a vector of p-values obtained from large scale statistical hypothesis testing}

\item{v}{the number of posterior sample saved}

\item{DPM.mcmc}{a list giving the MCMC a list giving the MCMC parameters for DPM fitting; see the argument \code{mcmc} of function \code{DPdensity()} in \code{DPpackage} for details; the default setting is \code{DPM.mcmc=list(nburn=2000,nsave=1,nskip=0,ndisplay=10)}}

\item{DPM.prior}{a list giving the prior information; see the argument \code{prior} of function \code{DPdensity()} in \code{DPpackage} for details; the default setting is \code{prior2}}
}
\value{
a list of density clustering results by the HODC algorithm 
\describe{
\item{mean}{a list containing posterior samples for the mean of unimportant and important clusters 
\describe{
\item{mu0}{a vector of length "v" containing posterior samples for the mean of the unimportant cluster}
\item{mu1}{a vector of length "v" containing posterior samples for the mean of the important cluster}
}
}
\item{variance}{a list containing posterior samples of the variance of the unimportant and the important clusters
\describe{
\item{var0}{a vector of length "v" containing posterior samples for the variance of the unimportant cluster}
\item{var1}{a vector of length "v" containing posterior samples for the variance of the important cluster}
}
}
\item{probability}{a list containing the probabilities of unimportant and important clusters
\describe{
\item{pro0}{a vector of length "v" containing posterior samples for the probability of the unimportant cluster}
\item{pro1}{a vector of length "v" containing posterior samples for the probability of the important cluster}
}
}
\item{classification}{a binary (0/1) matrix of dimension "v" by length(pvalue) containing posterior samples for two cluster classification results}
}
}

\references{
Yize Zhao, Jian Kang, Tianwei Yu (2014) A Bayesian nonparameteric model for selecting gene and gene sub-network, Annals of Applied Statistics, in press. 

Zhou Lan, Jian Kang, Tianwei Yu, Yize Zhao, BANFF: an R package for network identifications via Bayesian nonparametric mixture models, working paper.
}
\author{
Zhou Lan, Jian Kang, Tianwei Yu and Yize Zhao


Department of Biostatistics and Bioinformatics, Emory University
}

\details{
This function calls \code{DPdensity} to estimate the marginal density of the testing statistics \strong{r}, converted from p-values, using a mixture of normal densities without incorporating the network information. Furthermore, it implements the HODC algorithm to classify density components into two clusters. We refer to them as the unimportant cluster and the important cluster, where the important cluster has a larger mean than the unimportant cluster. 
}
\examples{
###random make the density
rstat=c(rnorm(50,mean=1),rnorm(50,mean=2),rnorm(100,mean=4)
,rnorm(100,mean=8))
###transformed into pvalue
pvalue=pnorm(-rstat)
DPMHODC=DPM.HODC(v=5,pvalue)
}

