% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratesHistogram.R
\name{ratesHistogram}
\alias{ratesHistogram}
\title{Histogram of \code{BAMM} rate frequencies}
\usage{
ratesHistogram(phylorates, plotBrks = TRUE, xlab = "speciation rate",
  ylab = "density", lwd = 0.2, lty = 1, brksCol = "black", ...)
}
\arguments{
\item{phylorates}{A saved \code{\link{plot.bammdata}} object.}

\item{plotBrks}{Boolean, should breaks be plotted over the histogram.}

\item{xlab}{x-axis label.}

\item{ylab}{y-axis label.}

\item{lwd}{Line width for breaks.}

\item{lty}{Line style for breaks.}

\item{brksCol}{Color of breaks lines.}

\item{\dots}{Additional arguments passed on to \code{mtext} for axis
labels.}
}
\description{
Plots a histogram of the frequency of rate values across the
    phylogeny.
}
\details{
With this function, a histogram is plotted that shows the
    frequency of rates present in the dataset. The color scheme plotted
    is taken from the saved \code{plot.bammdata} object that is the main
    input. Therefore, the mapping of colors to rates in the histogram
    corresponds exactly to what is plotted in the phylorate plot. If
    \code{plotBrks = TRUE}, then the color breaks used for the phylorates
    plot are shown. 

    This function can be a useful tool for exploring different
    \code{plot.bammdata} options. Please see
    \url{http://bamm-project.org/colorbreaks.html} on the bamm-project
    website for more information on the utility of this function.
}
\examples{
data(primates, events.primates)
ed <- getEventData(primates, events.primates, burnin=0.25, nsamples=500,
                   type = 'trait')

# create phylorate plot with the jenks breaks method to generate output
phylorates <- plot(ed, breaksmethod='jenks', show = FALSE)

ratesHistogram(phylorates, plotBrks = TRUE, xlab = 'trait rates')
}
\author{
Pascal Title
}
\references{
\url{http://bamm-project.org}
}
\seealso{
\code{\link{plot.bammdata}}
}

