\name{reality}
\alias{reality}
\alias{computer.model}
\alias{phi.true.toy}
\alias{phi.true}
\title{Reality}
\description{  
  Function to compute reality, gratis \emph{deus ex machina}.  Includes a
  simple computer model that substitutes for a complex climate model,
  and a simple function that substitutes for the base system, in this
  case the climate.
}
\usage{
reality(X, set.seed.to.zero=TRUE, draw.from.prior=FALSE, export.true.hyperparameters=FALSE,phi=NULL)
computer.model(X, params=NULL, set.seed.to.zero=TRUE,
draw.from.prior=FALSE, export.true.hyperparameters=FALSE,phi=NULL)
phi.true.toy(phi)
}
\arguments{
  \item{X}{Observation point}
  \item{params}{Parameters needed by \code{computer.model()}}
  \item{set.seed.to.zero}{Boolean, with the default value of \code{TRUE}
    meaning to set the RNG seed to zero}
  \item{draw.from.prior}{Boolean, with default \code{FALSE} meaning to
    generate obsevations from the \dQuote{true} values of the
    parameters, and \code{TRUE} meaning to draw from the relevant
    apriori distribution.}
  \item{export.true.hyperparameters}{Boolean, with default value
    of \code{FALSE} meaning to return the observed scalar.  Set to
    \code{TRUE} to exercise omniscience and access the \emph{true}
    values of the parameters and hyperparameters.  Only the omnipotent
    should set this variable, and only the omniscient may see its true
    value.}
  \item{phi}{In function \code{phi.true.toy()} the hyperparameters
    \eqn{\phi}{phi}.  Note that apriori distributions are unchanged
    (they are irrelevant to omniscient beings).

    In functions \code{reality()} and \code{computer.model()}, the prior
  distributions of the hyperparameters is passed via \code{phi} (so it
  only elements \code{psi1.apriori} and \code{psi2.apriori} need to be set).
  }
}
\details{
  Function \code{reality()} provides \emph{the} scalar value observed at
  a point \code{x}.  Evaluation expense is zero; there is no overhead.

  (However, it does not compute \dQuote{reality}: the function returns a
  value subject to observational error \eqn{N(0,\lambda)}{N(0,lambda)}
  as per equation 5.  It might be better to call this function
  \code{observation()})

  Function \code{computer.model()} returns the output of a simple,
  nonlinear computer model.

  Both functions documented here return a random variable drawn from an
  appropriate (correlated) multivariate Gaussian distribution, and are
  thus Gaussian processes.

  The approach is more explicit in the help pages of the emulator
  package.  There, Gaussian processes are generated by directly invoking
  \code{rmvnorm()} with a suitable correlation matrix.
  
}
\references{
  M. C. Kennedy and A. O'Hagan 2001. \dQuote{Bayesian
    calibration of computer models}.  Journal of the Royal Statistical
  Society B, 63(3) pp425-464
  
  M. C. Kennedy and A. O'Hagan 2001.  \dQuote{Supplementary details on
    Bayesian calibration of computer models}, Internal report, University
  of Sheffield.  Available at \url{http://www.shef.ac.uk/~st1ao/ps/calsup.ps}
  
  R. K. S. Hankin 2005. \dQuote{Introducing BACCO, an R bundle for
    Bayesian analysis of computer code output}, Journal of Statistical
  Software, 14(16)
}
\author{Robin K. S. Hankin}
\seealso{\code{\link{computer.model}}}
\examples{

  data(toys)


  computer.model(X=D2.toy,params=theta.toy)
  computer.model(D1.toy)
  computer.model(X=x.toy, params=extractor.toy(D1.toy)$t.vec)


  phi.fix <- phi.change(old.phi=phi.toy,
           psi1=c(1, 0.5, 1, 1, 0.5,  0.4),phi.fun=phi.fun.toy)
      #The values come from c(REAL.SCALES,REAL.SIGMA1SQUARED) as
      #seen in the sourcecode for computer.model().

  computer.model(D1.toy)   # use debug(computer.model) and examine
                           # var.matrix directly.  It should match the
                           #  output from V1():


          # first fix phi so that it has the correct values for psi1 (see the
          # section on psi1 in ?phi.fun.toy for how to get this):

   phi.fix <- phi.change(old.phi=phi.toy,psi1=c(1, 0.5, 1.0, 1.0, 0.5,
   0.4), phi.fun=phi.fun.toy)
   V1(D1.toy,phi=phi.fix)


  \dontrun{
     #  following lines not run because
     #  is.omniscient(user) implies  user != rksh

     computer.model(export=TRUE)
     reality(export=TRUE)
  }



# What is reality at the field observation points?
reality(D2.toy)

# What is reality at the code evaluation points?
reality(extractor.toy(D1.toy)$x.star)

# What is reality at x.toy?
reality(x.toy)

# Does reality correspond to our model?
reality(x.toy) - computer.model(X=x.toy, params=theta.toy)

# What are the hyperparameters that were used to create reality?
phi.true.toy(phi=phi.toy)

# 
 computer.model(X=D2.toy,params=theta.toy,draw.from.prior=TRUE,phi=phi.toy)

# What is the nature of reality?
reality

## Open questions:

# What is the reality of nature?
# What is the nature of nature?
# What is the reality of reality?

}
\keyword{array}
