% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_json.R
\name{build_template_definition.vm_config}
\alias{build_template_definition.vm_config}
\alias{build_template}
\alias{build_template_definition.vmss_config}
\alias{build_template_parameters.vm_config}
\alias{build_template_parameters.vmss_config}
\title{Build template definition and parameters}
\usage{
\method{build_template_definition}{vm_config}(config, ...)

\method{build_template_definition}{vmss_config}(config, ...)

\method{build_template_parameters}{vm_config}(config, name, login_user, size, ...)

\method{build_template_parameters}{vmss_config}(config, name, login_user, size, instances, ...)
}
\arguments{
\item{config}{An object of class \code{vm_config} or \code{vmss_config} representing a virtual machine or scaleset deployment.}

\item{...}{Unused.}

\item{name}{The VM or scaleset name. Will also be used for the domain name label, if a public IP address is included in the deployment.}

\item{login_user}{An object of class \code{user_config} representing the login details for the admin user account on the VM.}

\item{size}{The VM (instance) size.}

\item{instances}{For \code{vmss_config}, the number of (initial) instances in the VM scaleset.}
}
\value{
Objects of class \code{json}, which are JSON character strings representing the deployment template and its parameters.
}
\description{
Build template definition and parameters
}
\details{
These are methods for the generics defined in the AzureRMR package.
}
\examples{

vm <- ubuntu_18.04()
build_template_definition(vm)
build_template_parameters(vm, "myubuntuvm",
    user_config("username", "~/.ssh/id_rsa.pub"), "Standard_DS3_v2")

}
\seealso{
\link{create_vm}, \link{vm_config}, \link{vmss_config}
}
