% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locks.R
\name{lock}
\alias{lock}
\alias{create_lock}
\alias{get_lock}
\alias{delete_lock}
\alias{list_locks}
\title{Management locks}
\description{
Create, retrieve and delete locks. These are methods for the \code{az_subscription}, \code{az_resource_group} and \code{az_resource} classes.
}
\section{Usage}{
\preformatted{create_lock(name, level = c("cannotdelete", "readonly"), notes = "")

get_lock(name)

delete_lock(name)

list_locks() 
}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of a lock.
\item \code{level}: The level of protection that the lock provides.
\item \code{notes}: An optional character string to describe the lock.
}
}

\section{Details}{

Management locks in Resource Manager can be assigned at the subscription, resource group, or resource level. They serve to protect a resource against unwanted changes. A lock can either protect against deletion (\code{level="cannotdelete"}) or against modification of any kind (\code{level="readonly"}).

Locks assigned at parent scopes also apply to lower ones, recursively. The most restrictive lock in the inheritance takes precedence. To modify/delete a resource, any existing locks for its subscription and resource group must also be removed.

Note if you logged in via a custom service principal, it must have "Owner" or "User Access Administrator" access to manage locks.
}

\section{Value}{

The \code{create_lock} and \code{get_lock} methods return a lock object, which is itself an Azure resource. The \code{list_locks} method returns a list of such objects. The \code{delete_lock} method returns NULL on a successful delete.

The \code{get_role_definition} method returns an object of class \code{az_role_definition}. This is a plain-old-data R6 class (no methods), which can be used as input for creating role assignments (see the examples below).

The \code{list_role_definitions} method returns a list of \code{az_role_definition} if the \code{as_data_frame} argument is FALSE. If this is TRUE, it instead returns a data frame containing the most broadly useful fields for each role definition: the definition ID and role name.
}

\examples{
\dontrun{

az <- get_azure_login("myaadtenant")
sub <- az$get_subscription("subscription_id")
rg <- sub$get_resource_group("rgname")
res <- rg$get_resource(type="provider_type", name="resname")

sub$create_lock("lock1", "cannotdelete")
rg$create_lock("lock2", "cannotdelete")

# error! resource is locked
res$delete()

# subscription level
rg$delete_lock("lock2")
sub$delete_lock("lock1")

# now it works
res$delete()

}
}
\seealso{
\link{rbac}

\href{https://docs.microsoft.com/en-us/azure/azure-resource-manager/resource-group-lock-resources}{Overview of management locks}
}
