% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anatomicalmassprop.R
\name{massprop_tail}
\alias{massprop_tail}
\title{Head mass properties}
\usage{
massprop_tail(m, l, w, start, end)
}
\arguments{
\item{m}{Mass of muscle (kg)}

\item{l}{Length of the tail (m)}

\item{w}{Width of the tail (m)}

\item{start}{a 1x3 vector (x,y,z) representing the 3D point where head starts.
Frame of reference: VRP | Origin: VRP}

\item{end}{a 1x3 vector (x,y,z) representing the 3D point where head ends.
Frame of reference: VRP | Origin: VRP}
}
\value{
This function returns a list that includes:
\itemize{
\item{I}{a 3x3 matrix representing the moment of inertia tensor of a head
modeled as a solid cone}
\item{CG}{a 1x3 vector representing the center of gravity position of a head
modeled as a solid cone}
\item{m}{a double that returns the head mass}
}
}
\description{
Calculate the moment of inertia of a tail modeled as a solid cone
}
\section{Warning}{

Parallel axis theorem does not apply between two arbitrary points.
One point must be the object's center of gravity.
}

\examples{
# refer to the vignette
library(AvInertia)

# load data
data(dat_id_curr, package = "AvInertia")
data(dat_bird_curr, package = "AvInertia")
data(dat_feat_curr, package = "AvInertia")
data(dat_bone_curr, package = "AvInertia")
data(dat_mat, package = "AvInertia")
data(clean_pts, package = "AvInertia")

# 1. Determine the center of gravity of the bird's torso (including the legs)
dat_torsotail_out = massprop_restbody(dat_id_curr, dat_bird_curr)
# 2. Calculate the inertia of the flight feathers about the tip of the calamus
feather_inertia <- compute_feat_inertia(dat_mat, dat_feat_curr, dat_bird_curr)
# 3. Determine the center of gravity of one of the bird's wings
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = 0)
# Visualize the center of gravity of each wing component in the x and y axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yx")
# or the y and z axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yz")
# 4. Combine all data and obtain the center of gravity, moment of inertia
# and principal axes of the bird
curr_full_bird      = combine_inertialprop(dat_torsotail_out,dat_wing_out,
dat_wing_out, dat_id_curr, dat_bird_curr, symmetric=TRUE)

}
\author{
Christina Harvey
}
