% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoScore_Ordinal.R
\name{compute_uni_variable_table_ordinal}
\alias{compute_uni_variable_table_ordinal}
\title{AutoScore-Ordinal function: Univariable Analysis}
\usage{
compute_uni_variable_table_ordinal(df, link = "logit", n_digits = 3)
}
\arguments{
\item{df}{data frame after checking}

\item{link}{The link function used to model ordinal outcomes. Default is
\code{"logit"} for proportional odds model. Other options are
\code{"cloglog"} (proportional hazards model) and \code{"probit"}.}

\item{n_digits}{Number of digits to print for OR or exponentiated
coefficients (Default:3).}
}
\value{
result of univariate analysis
}
\description{
Perform univariable analysis and generate the result table with
  odd ratios from proportional odds models.
}
\examples{
data("sample_data_ordinal")
# Using just a few variables to demonstrate usage:
uni_table<-compute_uni_variable_table_ordinal(sample_data_ordinal[, 1:3])
}
