% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoScore.R
\name{AutoScore_weighting}
\alias{AutoScore_weighting}
\title{AutoScore STEP(iii): Generate the initial score with the final list of variables (Re-run AutoScore Modules 2+3)}
\usage{
AutoScore_weighting(
  train_set,
  validation_set,
  final_variables,
  max_score = 100,
  categorize = "quantile",
  max_cluster = 5,
  quantiles = c(0, 0.05, 0.2, 0.8, 0.95, 1)
)
}
\arguments{
\item{train_set}{A processed \code{data.frame} that contains data to be analyzed, for training.}

\item{validation_set}{A processed \code{data.frame} that contains data for validation purpose.}

\item{final_variables}{A vector containing the list of selected variables, selected from Step(ii)\code{\link{AutoScore_parsimony}}. Run \code{vignette("Guide_book", package = "AutoScore")} to see the guidebook or vignette.}

\item{max_score}{Maximum total score (Default: 100).}

\item{categorize}{Methods for categorize continuous variables. Options include "quantile" or "kmeans" (Default: "quantile").}

\item{max_cluster}{The max number of cluster (Default: 5). Available if \code{categorize = "kmeans"}.}

\item{quantiles}{Predefined quantiles to convert continuous variables to categorical ones. (Default: c(0, 0.05, 0.2, 0.8, 0.95, 1)) Available if \code{categorize = "quantile"}.}
}
\value{
Generated \code{cut_vec} for downstream fine-tuning process STEP(iv) \code{\link{AutoScore_fine_tuning}}.
}
\description{
AutoScore STEP(iii): Generate the initial score with the final list of variables (Re-run AutoScore Modules 2+3)
}
\references{
\itemize{
 \item{Xie F, Chakraborty B, Ong MEH, Goldstein BA, Liu N. AutoScore: A Machine Learning-Based Automatic Clinical Score Generator and
  Its Application to Mortality Prediction Using Electronic Health Records. JMIR Medical Informatics 2020;8(10):e21798}
}
}
\seealso{
\code{\link{AutoScore_rank}}, \code{\link{AutoScore_parsimony}}, \code{\link{AutoScore_fine_tuning}}, \code{\link{AutoScore_testing}}, Run \code{vignette("Guide_book", package = "AutoScore")} to see the guidebook or vignette.
}
