% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AssayCorrector.R
\name{detect_bias}
\alias{detect_bias}
\title{Detect the type of bias present in the assay}
\usage{
detect_bias(assay, alpha = 0.01, type = "P", test = "AD")
}
\arguments{
\item{assay}{The assay to be corrected. Has to be an \code{assay} object.}

\item{alpha}{Significance level threshold (defaults to 0.01)}

\item{type}{\code{P}:plate-specific, \code{A}:assay-specific, \code{PA}:plate then assay-specific, \code{AP}:assay then plate-specific}

\item{test}{\code{KS}:Kolmogorov-Smirnov (1933), \code{AD}:Anderson-Darling (1952), \code{CVM}:Cramer-von-Mises (1928)}
}
\value{
The corrected assay (\code{assay} object)
}
\description{
\code{detect}  (1) identifies rows and columns of all plates of the assay affected by spatial bias (following the results of the Mann-Whitney U test); (2) identifies well locations (i.e., well positions scanned across all plates of a given assay) affected by spatial bias (also following the results of the Mann-Whitney U test).
}
\examples{
assay<-create_assay(m)
detected<-detect_bias(assay)
}
