% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterEM.R
\name{filterEM}
\alias{filterEM}
\title{Filter expression matrix based on annotation}
\usage{
filterEM(probes_expr, probe2gene)
}
\arguments{
\item{probes_expr}{is an expression matrix which rownames are probes of probe2gene and each column is a sample}

\item{probe2gene}{the first column is probes and the second column is corresponding gene symbols}
}
\value{
a expression matrix which has been filtered duplicated gene symbols
}
\description{
\code{filterEM} will annotate the probes in expression matrix and remove the duplicated gene symbols.
because there will be many probes mapped to same genes, we will only keep the max value one.
}
\examples{
attach(GSE95166)
# head(probes_expr)
# head(probe2gene)
genes_expr <- filterEM(probes_expr,probe2gene)
# head(genes_expr)
}
