% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APDREcorr.R
\name{APDREcorr}
\alias{APDREcorr}
\title{APDREcorr Correlations between Activity Patterns using APD GLMMs}
\usage{
APDREcorr(
  focal,
  cont1,
  cont2 = NULL,
  cont3 = NULL,
  cont4 = NULL,
  RE1,
  RE2 = NULL,
  weibullGLMM = TRUE,
  frechetGLMM = TRUE,
  gammaGLMM = TRUE,
  lognormalGLMM = FALSE,
  invgaussianGLMM = TRUE,
  cores = 1,
  iter = 5000,
  minESS = 1000,
  burnin = iter/2,
  thin = 1,
  adapt_delta = 0.95,
  center = "pi",
  adjust = 1,
  Reloo = TRUE,
  plothist = TRUE,
  ploteffects = TRUE,
  histcol = "cyan4",
  effectcol = "cyan4",
  linecol = "red"
)
}
\arguments{
\item{focal}{Vector of observations in radians of one species/group/individual/etc. for which predictions on another will be made.}

\item{cont1}{Vector of observations in radians, or output from generalized circular mixture model of activity curves from \code{\link[activityGCMM]{GCMM}}, of a species/group/individual/etc. from which predictions will be made}

\item{cont2}{Optional vector of observations in radians, or output from generalized circular mixture model of activity curves from \code{\link[activityGCMM]{GCMM}}, of additional species/group/individual/etc. from which predictions will be made}

\item{cont3}{Optional vector of observations in radians, or output from generalized circular mixture model of activity curves from \code{\link[activityGCMM]{GCMM}}, of additional species/group/individual/etc. from which predictions will be made}

\item{cont4}{Optional vector of observations in radians, or output from generalized circular mixture model of activity curves from \code{\link[activityGCMM]{GCMM}}, of additional species/group/individual/etc. from which predictions will be made}

\item{RE1}{Vector identifying a random intercept for observations of the focal to control for hierarchical data (e.g. camera trap IDs)}

\item{RE2}{Optional vector identifying levels of a second random effect, for data with additional hierarchical levels (e.g. study sites, sampling periods, data collection seasons); default is NULL}

\item{weibullGLMM}{Specifies whether to run a weibull GLMM, using the brms package; default is TRUE for all and results from the best-fitting model are returned}

\item{frechetGLMM}{Specifies whether to run a frechet GLMM, using the brms package; default is TRUE for all and results from the best-fitting model are returned}

\item{gammaGLMM}{Specifies whether to run a Gamma GLMM, using the brms package; default is TRUE for all and results from the best-fitting model are returned}

\item{lognormalGLMM}{Specifies whether to run a lognormal GLMM, using the brms package; default is TRUE for all and results from the best-fitting model are returned}

\item{invgaussianGLMM}{Specifies whether to run a inverse.gaussian GLMM, using the brms package; default is TRUE for all and results from the best-fitting model are returned}

\item{cores}{Number of cores to use when running MCMC chains in parallel; default=1}

\item{iter}{Number of MCMC iteractions per chain; burnin is iter/2; default=5000}

\item{minESS}{Desired minimum effective sample size; default=1000}

\item{burnin}{Number of MCMC iterations to be discarded as the burn-in; default=iter/2}

\item{thin}{Thinning rate for saving MCMC draws; default=1}

\item{adapt_delta}{Value to use for adapt_delta with brms; default=0.95; see also \code{\link{brms}}}

\item{center}{Value to use as center of graph; default=pi}

\item{adjust}{Smoothing of predicted line; recommended to use default value for observed values and higher value for estimations from circular models}

\item{Reloo}{Whether to use reloo when running leave-one-out cross-validation of models (loo); see also \code{\link{brms}} and \code{\link{loo}}}

\item{plothist}{Whether to plot histograms of samples from the posterior distribution for the correlation parameters; default=TRUE}

\item{ploteffects}{Whether to plot predicted effects; default=TRUE}

\item{histcol}{Colour for histogram bars}

\item{effectcol}{Colour for predicted effect plot 95\% HDI}

\item{linecol}{Colour for histogram lines for the 95\% HDI and 0}
}
\value{
Prints results of best-fitting model and posterior samples and/or predicted effects of parameter estimates if \code{plothist=TRUE}
and \code{ploteffects=TRUE}, and returns object of class \code{APD} with list of analysis results and information.

\code{data} List of data used in analysis

\code{model} Object of class \code{brmsfit} containing results and information for best-fitting model.

\code{distribution} Character vector of statistical distribution of best-fitting model

\code{allmodels} List of output for all tested models; object of class \code{brmsfit}
}
\description{
Calculates estimated relationships between activity probability density (APD) of the focal and contingent(s) using Bayesian GLMMs with 'STAN'
using \code{\link[brms]{brm}}, with the option to automatically select the statistical distribution that best fits the dataset (weibull,
frechet, gamma, lognormal, inverse gaussian) by \code{\link[loo]{loo}}. The function automatically ensures that MCMC chains reach
convergence and that the specified minimum effective sample size from the posterior distribution is achieved.

Package: AnimalAPD
Version: 1.0.0
Date: 2020-11-10
}
\examples{
data(wolfexample)
data(boarexample)
\donttest{APDREcorr(focal=wolfexample$Radians,cont1=boarexample$Radians,
    RE1=wolfexample$SamplingPeriod)}


}
\seealso{
\code{\link[activityGCMM]{GCMM}} \code{\link[brms]{brm}} \code{\link[loo]{loo}}
}
\author{
Liz AD Campbell
}
\keyword{Bayesian}
\keyword{activity;}
\keyword{cameratrap;}
\keyword{temporal;}
