% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Indices.R
\name{listIndices}
\alias{listIndices}
\title{List all indices on an Andromeda table}
\usage{
listIndices(tbl)
}
\arguments{
\item{tbl}{An \code{\link{Andromeda}} table (or any other 'DBI' table).}
}
\value{
Returns a tibble listing the indices, indexed columns, and whether the index is unique.
}
\description{
List all indices on an Andromeda table
}
\details{
Lists any indices that may have been created using the  \code{\link[=createIndex]{createIndex()}} function.
}
\examples{
andr <- andromeda(cars = cars)

createIndex(andr$cars, "speed")

listIndices(andr$cars)
# # A tibble: 1 x 5
# indexSequenceId indexName                unique columnSequenceId columnName
#           <int> <chr>                    <lgl>             <int> <chr>     
#1              0 idx_ocy8we9j2i7ld0rshgb4 FALSE                 0 speed           

close(andr)

}
\seealso{
\code{\link[=createIndex]{createIndex()}}, \code{\link[=removeIndex]{removeIndex()}}
}
