% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iff.0.r
\docType{methods}
\name{rawToIFFChunk}
\alias{rawToIFFChunk}
\alias{rawToIFFChunk,raw-method}
\title{Coerce raw data to an IFFChunk class object}
\usage{
\S4method{rawToIFFChunk}{raw}(x)
}
\arguments{
\item{x}{A vector of raw data that needs to be converted into a \code{\link{IFFChunk}}
class object.}
}
\value{
Returns an \code{\link{IFFChunk}} class object based on \code{x}.
}
\description{
Coerce raw data, as it would be stored in the Interchange File Format (IFF), and
convert it into an \code{\link{IFFChunk}} class object.
}
\details{
This method should work for all IFF chunk types that are implemented in this package
(see \code{\link{IFFChunk-method}} for details). For non-implemented chunks this method
may work properly as long as the chunks are nested inside a FORM type container chunk.
This method is provided for your convenience, but it is recommended to import IFFChunk
methods using the \code{\link{read.iff}} function. Use \code{\link[AmigaFFH]{as.raw}}
to achieve the inverse of this method.
}
\examples{
\dontrun{
## Get an IFFChunk object:
example.iff <- read.iff(system.file("ilbm8lores.iff", package = "AmigaFFH"))

## Coerce it to raw data:
example.raw <- as.raw(example.iff)

## Coerce raw data to IFF chunk:
example.iff.new <- rawToIFFChunk(example.raw)

## These conversions were non-destructive:
identical(example.iff, example.iff.new)
}
}
\seealso{
Other iff.operations: \code{\link{IFFChunk-class}},
  \code{\link{WaveToIFF}}, \code{\link{as.raster}},
  \code{\link{as.raw}}, \code{\link{getIFFChunk}},
  \code{\link{interpretIFFChunk}},
  \code{\link{rasterToIFF}}, \code{\link{read.iff}},
  \code{\link{write.iff}}

Other raw.operations: \code{\link{as.raw}},
  \code{\link{colourToAmigaRaw}}, \code{\link{packBitmap}},
  \code{\link{rawToAmigaIcon}},
  \code{\link{rawToHWSprite}},
  \code{\link{rawToSysConfig}},
  \code{\link{simpleAmigaIcon}}
}
\author{
Pepijn de Vries
}
