% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iff.0.r
\docType{class}
\name{IFFChunk-class}
\alias{IFFChunk-class}
\title{A class structure to represent IFF files}
\description{
An S4 class structure to represent data stored in the Interchange File
Format (IFF).
}
\details{
The Interchange File Format (IFF) was introduced in 1985 by Electronic Arts.
This format stores files in standardised modular objects, called `chunks'.
At the start of each chunk it is specified what type of data can be expected
and what the size of this data is. This was a very forward thinking way of
storing data, similar structures are still used in modern file formats (such
as PNG images and XML files).

Although the IFF format is still in use, and new standardised chunk types can
still be registered, this package will focus on the older chunk types that
were primarely used on the Commodore Amiga (OS <= 3.0). IFF files could
contain any kind of information. It could contain bitmap images, but also
audio clips or (formatted) texts.

The \code{IFFChunk} class is designed such that it theoretically can hold
any type of IFF data. This package will mostly focus on the early IFF file types
(i.e., IFF chunks as originally registered by Electronic Arts). IFF files are
read by this package in a none lossy way (\code{\link{read.iff}}), such that all
information is preserved (even if it is of an unknown type, as long as the chunk
identifier is 4 characters long).

This means that the object needs to be interpreted in order to make sense out of
it (\code{\link{interpretIFFChunk}}). This interpretation returns simplified
interpretations of class \code{IFF.ANY} when it is supported (see
\code{\link{IFFChunk-method}} for supported chunk types). Note that in the
interpretation process (meta-)information may get lost. converting
\code{IFF.ANY} objects back into \code{\link{IFFChunk}} objects (if possible)
could therefore result in an object that is different from then one stored in the
original file and could even destroy the correct interpretation of IFF objects.
IFF files should thus be handled with care.
}
\section{Slots}{

\describe{
\item{\code{chunk.type}}{A four \code{character} long code reflecting the type of
information represented by this chunk.}

\item{\code{chunk.data}}{A \code{list} that holds either one or more valid
\code{IFFChunk}s or a single \code{vector} of \code{raw} data. This data
can only be interpreted in context of the specified type or in some cases
information from other \code{IFFChunk}s.}
}}

\examples{
\dontrun{
## load an IFF file
example.iff <- read.iff(system.file("ilbm8lores.iff", package = "AmigaFFH"))

## 'example.iff' is of class IFFChunk:
class(example.iff)

## let's plot it:
plot(example.iff)

## The default constructor will create an empty FORM:
new("IFFChunk")

## The constructor can also be used to create simple chunks:
new("IFFChunk",
    chunk.type = "TEXT",
    chunk.data = list(charToRaw("A simple chunk")))
}
}
\references{
\url{http://wiki.amigaos.net/wiki/IFF_Standard}

\url{http://wiki.amigaos.net/wiki/IFF_FORM_and_Chunk_Registry}

\url{https://en.wikipedia.org/wiki/Interchange_File_Format}
}
\seealso{
Other iff.operations: \code{\link{WaveToIFF}},
  \code{\link{as.raster}}, \code{\link{as.raw}},
  \code{\link{getIFFChunk}},
  \code{\link{interpretIFFChunk}},
  \code{\link{rasterToIFF}}, \code{\link{read.iff}},
  \code{\link{write.iff}}
}
\author{
Pepijn de Vries
}
