% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrids.R
\name{setPhenoProgTest}
\alias{setPhenoProgTest}
\title{Set progeny test as phenotype}
\usage{
setPhenoProgTest(
  pop,
  testPop,
  nMatePerInd = 1L,
  use = "pheno",
  h2 = NULL,
  H2 = NULL,
  varE = NULL,
  corE = NULL,
  reps = 1,
  fixEff = 1L,
  p = NULL,
  onlyPheno = FALSE,
  simParam = NULL
)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{testPop}{an object of \code{\link{Pop-class}}}

\item{nMatePerInd}{number of times an individual in 'pop' is mated to an 
individual in testPop}

\item{use}{true genetic value (\code{gv}) or phenotypes (\code{pheno}, default)}

\item{h2}{a vector of desired narrow-sense heritabilities for
each trait. See details in \code{\link{setPheno}}.}

\item{H2}{a vector of desired broad-sense heritabilities for
each trait. See details in \code{\link{setPheno}}.}

\item{varE}{error (co)variances for traits. 
See details in \code{\link{setPheno}}.}

\item{corE}{an optional matrix for correlations between errors. 
See details in \code{\link{setPheno}}.}

\item{reps}{number of replications for phenotype. 
See details in \code{\link{setPheno}}.}

\item{fixEff}{fixed effect to assign to the population. Used 
by genomic selection models only.}

\item{p}{the p-value for the environmental covariate 
used by GxE traits. If NULL, a value is
sampled at random.}

\item{onlyPheno}{should only the phenotype be returned, see return}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns an object of \code{\link{Pop-class}} or 
a matrix if onlyPheno=TRUE
}
\description{
Models a progeny test of individuals in 'pop'. Returns 'pop' with a phenotype 
representing the average performance of their progeny. The phenotype is generated
by mating individuals in 'pop' to randomly chosen individuals in testPop a 
number of times equal to 'nMatePerInd'.
}
\details{
The reps parameter is for convenient representation of replicated data. 
It was intended for representation of replicated yield trials in plant 
breeding programs. In this case, varE is set to the plot error and 
reps is set to the number plots per entry. The resulting phenotype 
would reflect the mean of all replications.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10, inbred=TRUE)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create two populations of 5 individuals
pop1 = newPop(founderPop[1:5], simParam=SP)
pop2 = newPop(founderPop[6:10], simParam=SP)

#Set phenotype according to a progeny test
pop3 = setPhenoProgTest(pop1, pop2, use="gv", simParam=SP)

}
