% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam_setCorE}
\alias{SimParam_setCorE}
\title{Set correlated error variance}
\arguments{
\item{corE}{a correlation matrix for the error variances}
}
\description{
Defines a correlation structure for default 
error variances. You must call \code{\link{SimParam_setVarE}} 
first to define the default error variances.
}
\section{Usage}{
 SP$setCorE(corE)
}

\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10, mean=c(0,0), var=c(1,1), corA=diag(2))
SP$setVarE(varE=c(1,1))
E = 0.5*diag(2)+0.5 #Positively correlated error
SP$setCorE(E)

}
