% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FixedAS.R
\name{ahull3d}
\alias{ahull3d}
\title{3D alpha hull for a given alpha}
\usage{
ahull3d(points, alpha, volume = FALSE)
}
\arguments{
\item{points}{the points given as a matrix with three columns}

\item{alpha}{positive number}

\item{volume}{Boolean, whether to return the volume of the alpha hull, 
\strong{but this is not always reliable}}
}
\value{
A \code{mesh3d} object, with an attribute \code{"volume"} if 
  \code{volume = TRUE}.
}
\description{
Computes the alpha hull of a set of points for a given alpha.
}
\note{
If you want to compute the alpha hull for several values of alpha, 
  then instead of using this function you can use the 
  \code{\link{fullAhull3d}} and the \code{\link{setAlpha}} functions.
}
\examples{
library(AlphaHull3D)
library(uniformly)
library(rgl)

set.seed(666L)
pts <- runif_in_torus(5000L, R = 3, r = 1)
ahull <- ahull3d(pts, alpha = 2)

open3d(windowRect = c(50, 50, 562, 562))
points3d(pts)
shade3d(ahull, color = "orange", alpha = 0.4)
}
