% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_loadLatest.R
\name{pat_loadLatest}
\alias{pat_loadLatest}
\title{Load PurpleAir time series data for a week}
\usage{
pat_loadLatest(id = NULL, label = NULL, pas = NULL, days = 7)
}
\arguments{
\item{id}{PurpleAir sensor 'deviceDeploymentID'.}

\item{label}{PurpleAir sensor 'label'.}

\item{pas}{PurpleAir Synoptic \emph{pas} object.}

\item{days}{Number of days of data to include (7 or 45).}
}
\value{
A PurpleAir Timeseries \emph{pat} object.
}
\description{
A pre-generated PurpleAir Timeseries \emph{pat} object will be 
loaded containing data for the most recent 7- or 45-day interval. Data are
loaded from the archive set with either \code{setArchiveBaseUrl()} or 
\code{setArchiveBaseDir()} for locally archived files.
}
\note{
Archive file names are 
generated with a unique "device-deployment" identifier by combining a unique 
location ID with a unique device ID. These \code{deviceDeploymentID} 
identifiers guarantee that movement of a sensor will result in the creation 
of a new time series.

Users may request a \emph{pat} object in one of two ways:

1) Pass in \code{id} with a valid a \code{deviceDeploymentID}

2) Pass in both \code{label} and \code{pas} so that the 
\code{deviceDeploymentID} can be looked up.
}
\examples{
\donttest{
library(AirSensor)

setArchiveBaseUrl("http://data.mazamascience.com/PurpleAir/v1")

pas <- pas_load()
pat <- pat_loadLatest(label = "SCSB_07", pas = pas)
pat_multiPlot(pat)
}
}
\seealso{
\link{pat_load}

\link{pat_loadMonth}

\link{pat_createNew}
}
