% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pas_filterArea.R
\name{pas_filterArea}
\alias{pas_filterArea}
\title{Rectangle area filtering for PurpleAir Synoptic objects}
\usage{
pas_filterArea(pas = NULL, w = NULL, e = NULL, s = NULL, n = NULL)
}
\arguments{
\item{pas}{PurpleAir Synoptic \emph{pas} object.}

\item{w}{West edge of area bounding box (deg E).}

\item{e}{East edge of area bounding box (deg E).}

\item{s}{South edge of area bounding box (deg N).}

\item{n}{North edge of area bounding box (deg N).}
}
\value{
A subset of the given \emph{pas} object.
}
\description{
Filters \emph{pas} object sensors based on a bounding box.
}
\examples{
library(AirSensor)

pas <- example_pas
range(pas$longitude)
range(pas$latitude)
scsb <- 
  pas \%>\%
  pas_filterArea(
    w = -118.10,
    e = -118.07,
    s = 33.75,
    n = 33.78
  )
range(scsb$longitude)
range(scsb$latitude)

if ( interactive() ) {
  pas_leaflet(scsb)
}

}
\seealso{
\link{pas_filter}, \link{pas_filterNear}
}
