% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PurpleAirSoH_dailyOtherFit.R
\name{PurpleAirSoH_dailyOtherFit}
\alias{PurpleAirSoH_dailyOtherFit}
\title{Daily fit values}
\usage{
PurpleAirSoH_dailyOtherFit(pat = NULL)
}
\arguments{
\item{pat}{PurpleAir Timeseries \emph{pat} object.}
}
\description{
This function calculates a daily linear model between
the \code{pm25_A}, \code{pm25_B}, \code{humidity}, and \code{temperature} 
channels. One r-squared value for each channel pair except \code{pm25_A}, 
\code{pm25_B}, and \code{humidity}, \code{temperature} will be returned for 
each day. All returned values are expected to hover near 0 for a properly
functioning sensor.
}
\examples{
library(AirSensor)
 
tbl <- 
  example_pat_failure_A \%>\%
  PurpleAirSoH_dailyOtherFit() 
  
timeseriesTbl_multiPlot(
  tbl, 
  ncol = 2,
  ylim = c(0,1)
)

timeseriesTbl_multiPlot(
  tbl, 
  autoRange = TRUE
)

}
