% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MM_analysis.R
\name{MM}
\alias{MM}
\title{Analysis: Michaelis-Menten Model}
\usage{
MM(
  trat,
  resp,
  error = "SE",
  ylab = "ylab",
  xlab = "xlab",
  theme = theme_classic(),
  legend.position = "top",
  point = "all",
  width.bar = NA,
  r2 = "all",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  comment = NA
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_bw())}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}

\item{width.bar}{Bar width}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{pointshape}{format point (default is 21)}

\item{comment}{Add text after equation}
}
\value{
The function returns a list containing the coefficients and their respective values of p; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean square error); largest and smallest estimated value and the graph using ggplot2 with the equation automatically.
}
\description{
This function performs regression analysis using the Michaelis-Menten model.
}
\details{
The Michaelis-Menten model is defined by:
\deqn{f(x, (VM,k)) = \frac{Vm \times x}{k + x}}
}
\examples{
data("granada")
attach(granada)
MM(time,WL)
}
\references{
Seber, G. A. F. and Wild, C. J (1989) Nonlinear Regression, New York: Wiley & Sons (p. 330).
}
\author{
Gabriel Danilo Shimizu
}
