% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activePathways.r
\name{columnSignificance}
\alias{columnSignificance}
\title{Determine which pathways are found to be significant using each column
individually}
\usage{
columnSignificance(scores, gmt, background, cutoff, significant,
  correction.method, pvals)
}
\arguments{
\item{scores}{A numerical matrix of p-values where each row is a gene and
each column is a test. Rownames should be the genes and colnames the names
of the tests. All values must be 0<=p<=1 with missing values removed or
converted to 1}

\item{gmt}{A GMT object to be used for enrichment analysis. If a filename, a
GMT object will be read from the file}

\item{background}{A character vector of gene names to be used as a
statistical background. By default, the background is all genes that appear
in \code{gmt}}

\item{cutoff}{A maximum p-value for a gene to be used for enrichment analysis.
Any genes with \code{adjusted.p.val > significant} will be discarded before testing}

\item{significant}{A number in [0,1] denoting the maximum p-value for a
pathway to be considered significantly enriched.}

\item{correction.method}{Method to correct p-values. See
\code{\link[stats]{p.adjust}} for details}

\item{pvals}{p-value for the pathways calculated by ActivePathways}
}
\value{
a data.table with columns 'term.id' and a column for each column
in \code{scores}, indicating whether each pathway was found to be
significant(TRUE) or not(FALSE) when considering only that column
}
\description{
Determine which pathways are found to be significant using each column
individually
}
