% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Achilles.R
\name{createIndices}
\alias{createIndices}
\title{Create indicies}
\usage{
createIndices(
  connectionDetails,
  resultsDatabaseSchema,
  outputFolder,
  sqlOnly = FALSE,
  verboseMode = TRUE,
  achillesTables = c("achilles_results", "achilles_results_dist")
)
}
\arguments{
\item{connectionDetails}{An R object of type \code{connectionDetails} created using the
function \code{createConnectionDetails} in the
\code{DatabaseConnector} package.}

\item{resultsDatabaseSchema}{Fully qualified name of database schema that we can write final
results to. Default is cdmDatabaseSchema. On SQL Server, this should
specifiy both the database and the schema, so for example, on SQL
Server, 'cdm_results.dbo'.}

\item{outputFolder}{Path to store logs and SQL files}

\item{sqlOnly}{TRUE = just generate SQL files, don't actually run, FALSE = run
Achilles}

\item{verboseMode}{Boolean to determine if the console will show all execution steps.
Default = TRUE}

\item{achillesTables}{Which achilles tables should be indexed? Default is both
achilles_results and achilles_results_dist.}
}
\value{
A collection of queries that were executed to drop any existing indices and create new indicies as 
specified.
}
\description{
Create indicies
}
\details{
Post-processing, create indices to help performance. Cannot be used with Redshift.
}
