% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATA.R
\name{ATA}
\alias{ATA}
\title{Automatic Time Series Analysis and Forecasting using Ata Method with Box-Cox Power Transformations Family and Seasonal Decomposition Techniques}
\usage{
ATA(
  X,
  Y = NULL,
  parP = NULL,
  parQ = NULL,
  parPHI = NULL,
  model.type = NULL,
  seasonal.test = NULL,
  seasonal.model = "decomp",
  seasonal.period = NULL,
  seasonal.type = NULL,
  seasonal.test.attr = NULL,
  find.period = NULL,
  accuracy.type = NULL,
  nmse = 3,
  level.fixed = FALSE,
  trend.opt = "none",
  h = NULL,
  train_test_split = NULL,
  holdout = FALSE,
  holdout.adjustedP = TRUE,
  holdout.set_size = NULL,
  holdin = FALSE,
  transform.order = "before",
  transform.method = NULL,
  transform.attr = NULL,
  lambda = NULL,
  shift = 0,
  initial.level = NULL,
  initial.trend = NULL,
  ci.level = 95,
  start.phi = NULL,
  end.phi = NULL,
  size.phi = NULL,
  negative.forecast = TRUE,
  print.out = TRUE,
  plot.out = TRUE
)
}
\arguments{
\item{X}{A numeric vector or time series of class \code{ts} or \code{msts} for in-sample.}

\item{Y}{A numeric vector or time series of class \code{ts} or \code{msts} for out-sample. If you do not have out-sample data, you can split in-sample data into training and test dataset with \code{train_test_split} argument.}

\item{parP}{Value of Level parameter \code{p}. If NULL or "opt", it is estimated. \code{p} has all integer values from 1 to \code{length(X)}.}

\item{parQ}{Value of Trend parameter \code{q}. If NULL or "opt", it is estimated. \code{q} has all integer values from 0 to \code{p}.}

\item{parPHI}{Value of Damping Trend parameter \code{phi}. If NULL or "opt", it is estimated. phi has all values from 0 to 1.}

\item{model.type}{An one-character string identifying method using the framework terminology. The letter "A" for additive model, the letter "M" for multiplicative model.
If NULL, both letters will be tried and the best model (according to the accuracy measure \code{accuracy.type}) returned.}

\item{seasonal.test}{Testing for stationary and seasonality. If TRUE, the method firstly uses \code{test="adf"}, Augmented Dickey-Fuller, unit-root test then the test returns the least number of differences required to pass the test at level \code{alpha}.
After the unit-root test, seasonal test applies on the stationary \code{X}.}

\item{seasonal.model}{A string identifying method for seasonal decomposition. If NULL, "decomp" method is default. c("none", "decomp", "stl", "stlplus", "tbats", "stR") phrases of methods denote
\itemize{
     \item{none}    : seasonal decomposition is not required.
     \item{decomp}     : classical seasonal decomposition. If \code{decomp}, the \code{stats} package will be used.
     \item{stl}        : seasonal-trend decomposition procedure based on loess developed by Cleveland et al. (1990). If \code{stl}, the \code{stats} and \code{forecast} packages will be used. Multiple seasonal periods are allowed.
     \item{stlplus}    : seasonal-trend decomposition procedure based on loess developed by Cleveland et al. (1990). If \code{stlplus}, the \code{stlplus} package will be used.
     \item{tbats}   : exponential smoothing state space model with Box-Cox transformation, ARMA errors, trend and seasonal components.
                            as described in De Livera, Hyndman & Snyder (2011). Parallel processing is used by default to speed up the computations. If \code{tbats}, the \code{forecast} package will be used. Multiple seasonal periods are allowed.
     \item{stR}        : seasonal-trend decomposition procedure based on regression developed by Dokumentov and Hyndman (2015). If \code{stR}, the \code{stR} package will be used. Multiple seasonal periods are allowed.
     \item{x13}        : seasonal-trend decomposition procedure based on X13ARIMA/SEATS. If \code{x13}, the \code{seasonal} package will be used.
     \item{x11}        : seasonal-trend decomposition procedure based on X11. If \code{x11}, the \code{seasonal} package will be used.
}}

\item{seasonal.period}{Value(s) of seasonal periodicity. If NULL, \code{frequency} of X is default  If \code{seasonal.period} is not integer, \code{X} must be \code{msts} time series object. c(s1,s2,s3,...) for multiple period. If \code{X} has multiple periodicity, "tbats" or "stR" seasonal model have to be selected.}

\item{seasonal.type}{An one-character string identifying method for the seasonal component framework. The letter "A" for additive model, the letter "M" for multiplicative model.
If NULL, both letters will be tried and the best model (according to the accuracy measure \code{accuracy.type}) returned.
If seasonal decomposition methods except \code{decomp} with "M", Box-Cox transformation with \code{lambda}=0 is selected.}

\item{seasonal.test.attr}{Attributes set for unit root, seasonality tests, X13ARIMA/SEATS and X11. If NULL, corrgram.tcrit=1.28, uroot.test="adf", suroot.test="correlogram", suroot.uroot=TRUE, uroot.type="trend", uroot.alpha=0.05, suroot.alpha=0.05, uroot.maxd=2, suroot.maxD=1, suroot.m=frequency(X), uroot.pkg="urca", multi.period="min", x13.estimate.maxiter=1500, x13.estimate.tol=1.0e-5, x11.estimate.maxiter=1500, x11.estimate.tol=1.0e-5. If you want to change, please use \code{ATA.SeasAttr} function and its output.
For example, you can use \code{seasonal.test.attr = ATA.SeasAttr(corrgram.tcrit=1.65)} equation in \code{ATA} function.}

\item{find.period}{Find seasonal period(s) automatically. If NULL, 0 is default. When \code{find.period},
\itemize{
     \item{0} : none
     \item{1} : single period with find.freq
     \item{2} : single period with \code{forecast::findfrequency}
     \item{3} : multiple period with find.freq & stR
     \item{4} : multiple period with find.freq & tbats
     \item{5} : multiple period with find.freq & stl
}}

\item{accuracy.type}{Accuracy measure for optimization of the best ATA Method forecasting. IF NULL, \code{sMAPE} is default.
\itemize{
     \item{lik}        : maximum likelihood functions
     \item{sigma}    : residual variance.
     \item{MAE}        : mean absolute error.
     \item{MSE}        : mean square error.
     \item{AMSE}    : Average MSE over first `nmse` forecast horizons using k-step forecast.
     \item{GAMSE}    : Average MSE over first `nmse` forecast horizons using one-step forecast.
     \item{RMSE}    : root mean squared error.
     \item{MPE}        : mean percentage error.
     \item{MAPE}    : mean absolute percentage error.
     \item{sMAPE}    : symmetric mean absolute percentage error.
     \item{MASE}    : mean absolute scaled error.
     \item{OWA}        : overall weighted average of MASE and sMAPE.
     \item{MdAE}    : median absolute error.
     \item{MdSE}    : median square error.
     \item{RMdSE}    : root median squared error.
     \item{MdPE}    : median percentage error.
     \item{MdAPE}    : median absolute percentage error.
     \item{sMdAPE}    : symmetric median absolute percentage error.
}}

\item{nmse}{If accuracy.type == "AMSE" or "GAMSE", nmse provides the number of steps for average multistep MSE (`2<=nmse<=30`).}

\item{level.fixed}{If TRUE, "pStarQ"  --> First, fits ATA(p,0) where p = p* is optimized for q=0. Then, fits ATA(p*,q) where q is optimized for p = p*.}

\item{trend.opt}{When \code{trend.opt},
\itemize{
     \item{none} : none
     \item{fixed} : "pBullet" --> Fits ATA(p,1) where p = p* is optimized for q = 1.
     \item{search} : "qBullet" --> Fits ATA(p,q) where p = p* is optimized for q = q* (q > 0). Then, fits ATA(p*,q) where q is optimized for p = p*.
}}

\item{h}{The number of steps to forecast ahead.
When the parameter is NULL; if the frequency of \code{X} is 4, the parameter is set to 8; if the frequency of \code{X} is 12, the parameter is set to 18; the parameter is set to 6 for other cases.}

\item{train_test_split}{If \code{Y} is NULL, this parameter divides \code{X} into two parts: training set (in-sample) and test set (out-sample). \code{train_test_split} is number of periods for forecasting and size of test set.
If the value is between 0 and 1, percentage of length is active.}

\item{holdout}{Default is FALSE. If TRUE, ATA Method uses the holdout forecasting for accuracy measure to select the best model. In holdout forecasting, the last few data points are removed from the data series.
The remaining historical data series is called in-sample data (training set), and the holdout data is called validation set (holdout set).
If TRUE, holdout.set_size will used for holdout data.}

\item{holdout.adjustedP}{Default is TRUE. If TRUE, parP will be adjusted by length of training - validation sets and in-sample set when the holdout forecasting is active.}

\item{holdout.set_size}{If \code{holdout} is TRUE, this parameter will be same as \code{h} for defining holdout set.}

\item{holdin}{Default is FALSE. If TRUE, ATA Method uses the hold-in forecasting for accuracy measure to select the best model. In hold-in forecasting, the last h-length data points are used for accuracy measure.}

\item{transform.order}{If "before", Box-Cox transformation family will be applied and then seasonal decomposition techniques will be applied. If "after", seasonal decomposition techniques will be applied and then Box-Cox transformation family will be applied.}

\item{transform.method}{Transformation method  --> "Box_Cox", "Sqrt", "Reciprocal", "Log", "NegLog", "Modulus", "BickelDoksum", "Manly", "Dual", "YeoJohnson", "GPower", "GLog". If the transformation process needs shift parameter,
\code{ATA.Transform} will calculate required shift parameter automatically.}

\item{transform.attr}{Attributes set for Box-Cox transformation. If NULL, bcMethod = "loglik", bcLower = 0, bcUpper = 1, bcBiasAdj = FALSE. If you want to change, please use \code{ATA.BoxCoxAttr} function and its output.}

\item{lambda}{Box-Cox power transformation family parameter. If NULL, data transformed before model is estimated.}

\item{shift}{Box-Cox power transformation family shifting parameter. If NULL, data transformed before model is estimated.}

\item{initial.level}{If NULL, FALSE is default. If FALSE, ATA Method calculates the pth observation in \code{X} for level.
If TRUE, ATA Method calculates average of first p value in \code{X}for level.}

\item{initial.trend}{If NULL, FALSE is default. If FALSE, ATA Method calculates the qth observation in \code{X(T)-X(T-1)} for trend.
If TRUE, ATA Method calculates average of first q value in \code{X(T)-X(T-1)} for trend.}

\item{ci.level}{Confidence Interval levels for forecasting.}

\item{start.phi}{Lower boundary for searching \code{parPHI}.If NULL, 0 is default.}

\item{end.phi}{Upper boundary for searching \code{parPHI}. If NULL, 1 is is default.}

\item{size.phi}{Increment step for searching \code{parPHI}. If NULL, the step size will be determined as the value that allows the bounds for the optimised value of \code{parPHI} to be divided into 20 equal parts.}

\item{negative.forecast}{Negative values are allowed for forecasting. Default value is TRUE. If FALSE, all negative values for forecasting are set to 0.}

\item{print.out}{Default is TRUE. If FALSE, summary of ATA Method is not shown.}

\item{plot.out}{Default is TRUE. If FALSE, graphics of ATA Method are not shown.}
}
\value{
Returns an object of class \code{ata}. The generic accessor functions \code{ATA.Forecast} and \code{ATA.Accuracy} extract useful features of the value returned by \code{ATA} and associated functions.
\code{ata} object is a list containing at least the following elements
\itemize{
		 \item{actual}		: The original time series.
		 \item{fitted}		: Fitted values (one-step forecasts). The mean is of the fitted values is calculated over the ensemble.
		 \item{level}		  : Estimated level values.
		 \item{trend}		  : Estimated trend values.
		 \item{residuals}	: Original values minus fitted values.
		 \item{coefp}		  : The weights attached to level observations.
		 \item{coefq}		  : The weights attached to trend observations.
		 \item{p}		      : Optimum level parameter.
		 \item{q}		      : Optimum trend parameter.
		 \item{phi}		    : Optimum damped trend parameter.
		 \item{model.type}: Form of trend.
		 \item{h}		      : The number of steps to forecast ahead.
		 \item{forecast}	: Point forecasts as a time series.
		 \item{out.sample}: Test set as a time series.
		 \item{method}		: The name of the optimum forecasting method as a character string for ATA(P,Q,PHI)(Error,Trend,Season).
		 \item{initial.level}     : Selected initial level values for the time series forecasting method.
		 \item{initial.trend}     : Selected initial trend values for the time series forecasting method.
		 \item{level.fixed}       : A choice of optional level-fixed trended methods.
    \item{trend.opt}       : A choice of optional trend and level optimized trended methods (none, trend.fixed or trend.search).
		 \item{transform.method}  : Box-Cox power transformation family method  --> Box_Cox, Sqrt, Reciprocal, Log, NegLog, Modulus, BickelDoksum, Manly, Dual, YeoJohnson, GPower, GLog.
		 \item{transform.order}   : Define how to apply Box-Cox power transformation techniques, before or after seasonal decomposition.
		 \item{lambda}  	: Box-Cox power transformation family parameter.
		 \item{shift}		  : Box-Cox power transformation family shifting parameter.
		 \item{accuracy.type}		  : Accuracy measure that is chosen for model selection.
		 \item{nmse}		  : The number of steps for average multistep MSE.
		 \item{accuracy} 	: In and out sample accuracy measures and its descriptives that are calculated for optimum model are given.
		 \item{par.specs} 	: Parameter sets for Information Criteria.
		 \item{holdout}		: Holdout forecasting is TRUE or FALSE.
		 \item{holdout.training} 	: Training set in holdout forecasting.
		 \item{holdout.validation}: Validation set in holdout forecasting.
		 \item{holdout.forecast}	: Holdout forecast.
		 \item{holdout.accuracy}	: Accuracy measure chosen for model selection in holdout forecasting.
		 \item{holdin}		: Hold-in forecasting is TRUE or FALSE.
		 \item{is.season}	: Indicates whether it contains seasonal pattern.
		 \item{seasonal.model}		: The name of the selected decomposition method.
		 \item{seasonal.type}	  	: Form of seasonality.
		 \item{seasonal.period}		: The number of seasonality periods.
		 \item{seasonal.index}		: Weights of seasonality.
		 \item{seasonal}	: Estimated seasonal values.
		 \item{seasonal.adjusted}	: Deseasonalized time series values.
		 \item{execution.time}		: The real and CPU time 'in seconds' spent by the system executing that task, including the time spent executing run-time or system services on its behalf.
		 \item{calculation.time}	: How much real time 'in seconds' the currently running R process has already taken.
}
}
\description{
\code{ATA} is a generic function for Ata Method forecasting.
The Ata method based on the modified simple exponential smoothing as described in Yapar, G. (2016) <doi:10.15672/HJMS.201614320580> ,
Yapar G., Capar, S., Selamlar, H. T., Yavuz, I. (2017) <doi:10.15672/HJMS.2017.493> and Yapar G., Selamlar, H. T., Capar, S., Yavuz, I. (2019)
<doi:10.15672/hujms.461032> is a new univariate time series forecasting method which provides innovative solutions to issues faced during
the initialization and optimization stages of existing methods.
Forecasting performance of the Ata method is superior to existing methods both in terms of easy implementation and accurate forecasting.
It can be applied to non-seasonal or seasonal time series which can be decomposed into four components (remainder, level, trend and seasonal).
This methodology performed well on the M3 and M4-competition data.
}
\details{
Returns ATA(p,q,phi)(E,T,S) applied to \code{X}.
}
\examples{
trainATA <-  head(touristTR, 84)
testATA <- window(touristTR, start = 2015, end = 2016.917)
ata_fit <- ATA(trainATA, h=24, parQ = 1, seasonal.test = TRUE, seasonal.model = "stl")
ata_fc <- ATA.Forecast(ata_fit, out.sample = testATA)
ata_accry <- ATA.Accuracy(ata_fc)

}
\references{
#'\insertRef{yapar2017mses}{ATAforecasting}

#'\insertRef{yapar2018mhes}{ATAforecasting}

#'\insertRef{yapar2018mses}{ATAforecasting}

#'\insertRef{yapar2019ata}{ATAforecasting}
}
\seealso{
\code{forecast}, \code{stlplus}, \code{stR}, \code{\link[stats]{stl}}, \code{\link[stats]{decompose}},
\code{tbats}, \code{seasadj}, \code{seasonal}.
}
\author{
Ali Sabri Taylan and Hanife Taylan Selamlar
}
\keyword{Ata}
\keyword{accuracy}
\keyword{forecast}
\keyword{msts}
\keyword{ts}
