% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wt_assign_tasks.R
\name{wt_assign_tasks}
\alias{wt_assign_tasks}
\title{Assign tasks for interpretation on Wildtrax}
\usage{
wt_assign_tasks(
  wt_task_template_in,
  interp_hours,
  wt_task_output_file,
  interp_hours_column,
  random_seed = NULL
)
}
\arguments{
\item{wt_task_template_in}{Path to csv template downloaded from Wildtrax
platform \url{https://wildtrax.ca} listing all tasks. Alternatively,
can be a data.frame that is correctly formatted using
\code{wildRtrax::wt_make_aru_tasks()}. See \code{vignette("Misc")} for details.}

\item{interp_hours}{Path to number of hours for each interpreter or a data.table. If a file, must be csv and must include
the columns "transcriber" and whatever the variable \code{interp_hours_column} is.}

\item{wt_task_output_file}{Path to csv of output file for uploading to Wildtrax. If left as NULL will not write file}

\item{interp_hours_column}{LazyEval column name with hours for interpreters}

\item{random_seed}{Integer. Random seed to select with. If left NULL will use timestamp}
}
\value{
Returns a list with a tibble of assigned tasks and a summary tibble.
}
\description{
Assign tasks for interpretation on Wildtrax
}
\examples{
  task_output <- wt_assign_tasks(
  wt_task_template_in = task_template,
  wt_task_output_file = NULL,
  interp_hours = template_observers,
  interp_hours_column = hrs,
  random_seed = 65122
  )

}
