% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logoddsratio.2x2.R
\name{logoddsratio.2x2}
\alias{logoddsratio.2x2}
\title{Perform Log odds ratio test}
\usage{
logoddsratio.2x2(
  x,
  y,
  max.exact.cases = 10,
  nsims.mc = 1e+05,
  seed = NULL,
  do.exact = TRUE,
  do.asymp = FALSE,
  do.mc = FALSE
)
}
\arguments{
\item{x}{Binary factor of same length as y}

\item{y}{Binary factor of same length as x}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{10})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{100000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.mc}{Boolean indicating whether or not to perform Monte Carlo calculations (defaults to \code{FALSE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{logoddsratio.2x2()} performs the Log odds ratio test and is used in chapter 13 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Exercise 13.2 from "Applied Nonparametric Statistical Methods" (5th edition)
#logoddsratio.2x2(ch13$physical.activity[ch13$gender == "Boy"],
#  ch13$tv.viewing[ch13$gender == "Boy"], do.exact = FALSE, do.asymp = TRUE)
#logoddsratio.2x2(ch13$physical.activity[ch13$gender == "Girl"],
#  ch13$tv.viewing[ch13$gender == "Girl"], do.exact = FALSE, do.asymp = TRUE)

}
