% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kruskal.wallis.vdW.R
\name{kruskal.wallis.vdW}
\alias{kruskal.wallis.vdW}
\title{Perform Kruskal-Wallis test with van der Waerden scores}
\usage{
kruskal.wallis.vdW(
  x,
  g,
  max.exact.cases = 15,
  nsims.mc = 10000,
  seed = NULL,
  do.asymp = FALSE,
  do.exact = TRUE
)
}
\arguments{
\item{x}{Numeric vector of same length as g}

\item{g}{Factor of same length as x}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{15})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{10000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{kruskal.wallis.vdW()} performs the Kruskal-Wallis test with van der Waerden scores and is used in chapter 7 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 7.2 from "Applied Nonparametric Statistical Methods" (5th edition)
kruskal.wallis.vdW(ch7$age, ch7$positions)
kruskal.wallis.vdW(ch7$age, ch7$positions, do.exact = FALSE, do.asymp = TRUE)

}
