% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av_from_text.R
\name{av_from_text}
\alias{av_from_text}
\title{Retrieve Antiviral Drug Names and Doses from Clinical Text}
\usage{
av_from_text(
  text,
  type = c("drug", "dose", "administration"),
  collapse = NULL,
  translate_av = FALSE,
  thorough_search = NULL,
  info = interactive(),
  ...
)
}
\arguments{
\item{text}{text to analyse}

\item{type}{type of property to search for, either \code{"drug"}, \code{"dose"} or \code{"administration"}, see \emph{Examples}}

\item{collapse}{a \link{character} to pass on to \code{paste(, collapse = ...)} to only return one \link{character} per element of \code{text}, see \emph{Examples}}

\item{translate_av}{if \code{type = "drug"}: a column name of the \link{antivirals} data set to translate the antibiotic abbreviations to, using \code{\link[=av_property]{av_property()}}. The default is \code{FALSE}. Using \code{TRUE} is equal to using "name".}

\item{thorough_search}{a \link{logical} to indicate whether the input must be extensively searched for misspelling and other faulty input values. Setting this to \code{TRUE} will take considerably more time than when using \code{FALSE}. At default, it will turn \code{TRUE} when all input elements contain a maximum of three words.}

\item{info}{a \link{logical} to indicate whether a progress bar should be printed - the default is \code{TRUE} only in interactive mode}

\item{...}{arguments passed on to \code{\link[=as.av]{as.av()}}}
}
\value{
A \link{list}, or a  \link{character} if \code{collapse} is not \code{NULL}
}
\description{
Use this function on e.g. clinical texts from health care records. It returns a \link{list} with all antiviral drugs, doses and forms of administration found in the texts.
}
\details{
This function is also internally used by \code{\link[=as.av]{as.av()}}, although it then only searches for the first drug name and will throw a note if more drug names could have been returned. Note: the \code{\link[=as.av]{as.av()}} function may use very long regular expression to match brand names of antiviral drugs. This may fail on some systems.
\subsection{Argument \code{type}}{

At default, the function will search for antiviral drug names. All text elements will be searched for official names, ATC codes and brand names. As it uses \code{\link[=as.av]{as.av()}} internally, it will correct for misspelling.

With \code{type = "dose"} (or similar, like "dosing", "doses"), all text elements will be searched for \link{numeric} values that are higher than 100 and do not resemble years. The output will be \link{numeric}. It supports any unit (g, mg, IE, etc.) and multiple values in one clinical text, see \emph{Examples}.

With \code{type = "administration"} (or abbreviations, like "admin", "adm"), all text elements will be searched for a form of drug administration. It supports the following forms (including common abbreviations): buccal, implant, inhalation, instillation, intravenous, nasal, oral, parenteral, rectal, sublingual, transdermal and vaginal. Abbreviations for oral (such as 'po', 'per os') will become "oral", all values for intravenous (such as 'iv', 'intraven') will become "iv". It supports multiple values in one clinical text, see \emph{Examples}.
}

\subsection{Argument \code{collapse}}{

Without using \code{collapse}, this function will return a \link{list}. This can be convenient to use e.g. inside a \code{mutate()}):\cr
\code{df \%>\% mutate(avx = av_from_text(clinical_text))}

The returned AV codes can be transformed to official names, groups, etc. with all \code{\link[=av_property]{av_*}} functions such as \code{\link[=av_name]{av_name()}} and \code{\link[=av_group]{av_group()}}, or by using the \code{translate_av} argument.

With using \code{collapse}, this function will return a \link{character}:\cr
\code{df \%>\% mutate(avx = av_from_text(clinical_text, collapse = "|"))}
}
}
\examples{
av_from_text("28/03/2020 valaciclovir po tid")
av_from_text("28/03/2020 valaciclovir po tid", type = "admin")
}
