% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewness.R
\name{skewness}
\alias{skewness}
\alias{skewness.default}
\alias{skewness.matrix}
\alias{skewness.data.frame}
\title{Skewness of the sample}
\usage{
skewness(x, na.rm = FALSE)

\method{skewness}{default}(x, na.rm = FALSE)

\method{skewness}{matrix}(x, na.rm = FALSE)

\method{skewness}{data.frame}(x, na.rm = FALSE)
}
\arguments{
\item{x}{a vector of values, a \code{\link{matrix}} or a \code{\link{data.frame}}}

\item{na.rm}{a logical value indicating whether \code{NA} values should be stripped before the computation proceeds.}
}
\description{
Skewness is a measure of the asymmetry of the probability distribution of a real-valued random variable about its mean.

When negative: the left tail is longer; the mass of the distribution is concentrated on the right of the figure. When positive: the right tail is longer; the mass of the distribution is concentrated on the left of the figure.
}
\section{Questioning lifecycle}{

\if{html}{\figure{lifecycle_questioning.svg}{options: style=margin-bottom:5px} \cr}
The \link[=lifecycle]{lifecycle} of this function is \strong{questioning}. This function might be no longer be optimal approach, or is it questionable whether this function should be in this \code{AMR} package at all.
}

\section{Read more on our website!}{

On our website \url{https://msberends.github.io/AMR} you can find \href{https://msberends.github.io/AMR/articles/AMR.html}{a comprehensive tutorial} about how to conduct AMR analysis, the \href{https://msberends.github.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.github.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}. As we would like to better understand the backgrounds and needs of our users, please \href{https://msberends.github.io/AMR/survey.html}{participate in our survey}!
}

\seealso{
\code{\link[=kurtosis]{kurtosis()}}
}
