% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ab_class_selectors.R
\name{antibiotic_class_selectors}
\alias{antibiotic_class_selectors}
\alias{ab_class}
\alias{aminoglycosides}
\alias{carbapenems}
\alias{cephalosporins}
\alias{cephalosporins_1st}
\alias{cephalosporins_2nd}
\alias{cephalosporins_3rd}
\alias{cephalosporins_4th}
\alias{cephalosporins_5th}
\alias{fluoroquinolones}
\alias{glycopeptides}
\alias{macrolides}
\alias{penicillins}
\alias{tetracyclines}
\title{Antibiotic class selectors}
\usage{
ab_class(ab_class)

aminoglycosides()

carbapenems()

cephalosporins()

cephalosporins_1st()

cephalosporins_2nd()

cephalosporins_3rd()

cephalosporins_4th()

cephalosporins_5th()

fluoroquinolones()

glycopeptides()

macrolides()

penicillins()

tetracyclines()
}
\arguments{
\item{ab_class}{an antimicrobial class, like \code{"carbapenems"}. The columns \code{group}, \code{atc_group1} and \code{atc_group2} of the \link{antibiotics} data set will be searched (case-insensitive) for this value.}
}
\description{
Use these selection helpers inside any function that allows \href{https://tidyselect.r-lib.org/reference/language.html}{Tidyverse selections}, like \code{dplyr::select()} or \code{tidyr::pivot_longer()}. They help to select the columns of antibiotics that are of a specific antibiotic class, without the need to define the columns or antibiotic abbreviations.
}
\details{
All columns will be searched for known antibiotic names, abbreviations, brand names and codes (ATC, EARS-Net, WHO, etc.). This means that a selector like e.g. \code{\link[=aminoglycosides]{aminoglycosides()}} will pick up column names like 'gen', 'genta', 'J01GB03', 'tobra', 'Tobracin', etc.

These functions only work if the \code{tidyselect} package is installed, that comes with the \code{dplyr} package. An error will be thrown if \code{tidyselect} package is not installed, or if the functions are used outside a function that allows Tidyverse selections like \code{select()} or \code{pivot_longer()}.
}
\examples{
\dontrun{
  library(dplyr)

  # this will select columns 'IPM' (imipenem) and 'MEM' (meropenem):
  example_isolates \%>\% 
    select(carbapenems())
    
  # this will select columns 'mo', 'AMK', 'GEN', 'KAN' and 'TOB':
  example_isolates \%>\% 
    select(mo, aminoglycosides())
    
  # this will select columns 'mo' and all antimycobacterial drugs ('RIF'):
  example_isolates \%>\% 
    select(mo, ab_class("mycobact"))
    
    
  # get bug/drug combinations for only macrolides in Gram-positives:
  example_isolates \%>\% 
    filter(mo_gramstain(mo) \%like\% "pos") \%>\% 
    select(mo, macrolides()) \%>\% 
    bug_drug_combinations() \%>\%
    format()
    
    
  data.frame(irrelevant = "value",
             J01CA01 = "S") \%>\%   # ATC code of ampicillin
    select(penicillins())         # so the 'J01CA01' column is selected

}
}
\seealso{
\code{\link[=filter_ab_class]{filter_ab_class()}} for the \code{filter()} equivalent.
}
