% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsi_analysis.R
\name{rsi_df}
\alias{rsi_df}
\title{Resistance of isolates in data.frame}
\usage{
rsi_df(tbl, antibiotics, interpretation = "IR", minimum = 30,
  percent = FALSE, info = TRUE, warning = TRUE)
}
\arguments{
\item{tbl}{\code{data.frame} containing columns with antibiotic interpretations.}

\item{antibiotics}{character vector with 1, 2 or 3 antibiotics that occur as column names in \code{tbl}, like \code{antibiotics = c("amox", "amcl")}}

\item{interpretation}{antimicrobial interpretation of which the portion must be calculated. Valid values are \code{"S"}, \code{"SI"}, \code{"I"}, \code{"IR"} or \code{"R"}.}

\item{minimum}{minimal amount of available isolates. Any number lower than \code{minimum} will return \code{NA} with a warning (when \code{warning = TRUE}).}

\item{percent}{return output as percent (text), will else (at default) be a double}

\item{info}{calculate the amount of available isolates and print it, like \code{n = 423}}

\item{warning}{show a warning when the available amount of isolates is below \code{minimum}}
}
\value{
Double or, when \code{percent = TRUE}, a character.
}
\description{
\strong{NOTE: use \code{\link{rsi}} in dplyr functions like \code{\link[dplyr]{summarise}}.} \cr Calculate the percentage of S, SI, I, IR or R of a \code{data.frame} containing isolates.
}
\details{
Remember that you should filter your table to let it contain \strong{only first isolates}!
}
\examples{
\dontrun{
rsi_df(tbl_with_bloodcultures, 'amcl')

rsi_df(tbl_with_bloodcultures, c('amcl', 'gent'), interpretation = 'IR')

library(dplyr)
# calculate current empiric therapy of Helicobacter gastritis:
my_table \%>\%
  filter(first_isolate == TRUE, 
         genus == "Helicobacter") \%>\%
  rsi_df(antibiotics = c("amox", "metr"))
}
}
\seealso{
\code{\link{rsi}} for the function that can be used with \code{\link[dplyr]{summarise}} directly.
}
\keyword{antibiotics}
\keyword{isolate}
\keyword{isolates}
\keyword{rsi}
