% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{chapter_11_table_19}
\alias{chapter_11_table_19}
\alias{C11T19}
\alias{Chapter_11_Table_19}
\alias{c11t19}
\title{The data used in Chapter 11, Table 19}
\format{
An object of class \code{data.frame} with 24 rows and 3 columns.
}
\source{
\url{https://designingexperiments.com/data/}

Maxwell, S. E., Delaney, H. D., & Kelley, K. (2018). \emph{Designing experiments and
analyzing data: {A} model comparison perspective}. (3rd ed.). New York, NY: Routledge.
}
\usage{
data(chapter_11_table_19)
}
\description{
The data used in Chapter 11, Table 19
}
\details{
Table 11.19 duplicates a table from Shrout and Fleiss showing hypothetical data obtained from four judges, each of whom has rated six targets (i.e., subjects). For the present (hypothetical) data set (taken from Shrout and Fleiss, 1979) consists of six participants who are ranked by four judges.

As is pointed out in the book, the structure of Table 11.19 is analogous to that of Table 11.5 (repeated measures). However, notice that in the data file that the data are entered differently. For the repeated measures design (e.g., Table 11.5), each row corresponded to a different participant, while each column corresponded with another measurement. The main reason for the difference in how the data was entered is mainly because of the procedures used to analyze the data. SPSS and SAS allow repeated measures data to be entered in a "participants by occasions" fashion, whereas in order to get the appropriate mean squares to carryout the intraclass correlations for the data given in Table 11.19, a mixed-effects (one fixed factor and one random factor) ANOVA needs to be performed.
}
\section{Variables}{

\describe{
\item{subject}{a numeric vector}
\item{judge}{judge number; of 3}
\item{rating}{a numeric vector}
}
}

\section{Synonym}{

C11T19
}

\examples{
# Load the data
data(chapter_11_table_19)

# Or, alternatively load the data as
data(C11T19)

# View the structure
str(chapter_11_table_19)

}
\references{
Maxwell, S. E., Delaney, H. D., \& Kelley, K. (2018). \emph{Designing experiments and analyzing data:
{A} model comparison perspective} (3rd ed.). New York, NY: Routledge.
}
\author{
Ken Kelley \email{kkelley@nd.edu}
}
\keyword{datasets}
