% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ALTopt.R
\name{altopt.ic}
\alias{altopt.ic}
\title{Optimal design with interval censoring.}
\usage{
altopt.ic(optType, N, t, k, nf, alpha, formula, coef, useCond, useLower,
  useUpper, nOpt = 1, nKM = 30, nCls = NULL)
}
\arguments{
\item{optType}{the choice of \code{"D"}, \code{"U"} and \code{"I"} optimality.}

\item{N}{the number of test units.}

\item{t}{the total testing time.}

\item{k}{the number of time intervals.}

\item{nf}{the number of stress factors.}

\item{alpha}{the value of the shape parameter of Weibull distribution.}

\item{formula}{the object of class formula which is the linear predictor model.}

\item{coef}{the numeric vector containing the coefficients of each term in \code{formula}.}

\item{useCond}{the numeric vector of use condition.
It should be provided when \code{optType} is \code{"U"}. The length of the vector
should be same as the number of stress factors.}

\item{useLower}{the numeric vector of lower bound of use region.
It should be provided when \code{optType} is \code{"I"}. The length of the vector
should be same as the number of stress factors.}

\item{useUpper}{the numeric vector of upper bound of use region.
It should be provided when \code{optType} is \code{"I"}. The length of the vector
should be same as the number of stress factors.}

\item{nOpt}{the number of repetition of optimization process. Default is 1.}

\item{nKM}{the number of repetition of k-means clustering. Default is 20.}

\item{nCls}{the number of clusters used for k-means clustering. If not specified,
it is set as the number of parameters in the linear predictor model.}
}
\value{
A list with components
\itemize{
  \item{call:}{ the matched call.}
  \item{opt.design.rounded:}{ the optimal design clustered by rounding in third decimal points.}
  \item{opt.value.rounded:}{ the objective function value of \code{opt.design.rounded}.}
  \item{opt.design.kmeans:}{ the optimal design clustered by \code{\link[stats]{kmeans}}.}
  \item{opt.value.kmeans:}{ the objective function value of \code{opt.design.kmeans}.}
}
}
\description{
\code{\link{altopt.ic}} creates D, U or I optimal design
of the accelerated life testing with interval censoring plan.
}
\examples{
\dontrun{
# Generating D optimal design for interval censoring.
altopt.ic("D", 100, 30, 5, 2, 1, formula = ~ x1 + x2 + x1:x2,
coef = c(0, -4.086, -1.476, 0.01))

# Generating U optimal design for interval censoring.
altopt.ic("D", 100, 30, 5, 2, 1, formula = ~ x1 + x2 + x1:x2,
coef = c(0, -4.086, -1.476, 0.01), useCond = c(1.758, 3.159))

# Generating I optimal design for interval censoring.
altopt.ic("D", 100, 30, 5, 2, 1, formula = ~ x1 + x2 + x1:x2,
coef = c(0, -4.086, -1.476, 0.01), useLower = c(1.458, 2.859),
useUpper = c(2.058, 3.459))
}
}
\references{
{
Monroe, E. M., Pan, R., Anderson-Cook, C. M., Montgomery, D. C. and
Borror C. M. (2011) A Generalized Linear Model Approach to Designing
Accelerated Life Test Experiments, \emph{Quality and Reliability Engineering
 International} \bold{27(4)}, 595--607

Yang, T., Pan, R. (2013) A Novel Approach to Optimal Accelerated Life Test
 Planning With Interval Censoring, \emph{Reliability, IEEE Transactions on}
  \bold{62(2)}, 527--536
}
}
\seealso{
\code{\link[stats]{kmeans}}, \code{\link{alteval.ic}}
}

