% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMReportMaker.R
\name{generateReportFromNanoscopeImageDirectory}
\alias{generateReportFromNanoscopeImageDirectory}
\title{Generate a pdf report for all AFM images in a directory}
\usage{
generateReportFromNanoscopeImageDirectory(imageDirectory, imageNumber)
}
\arguments{
\item{imageDirectory}{a directory where are located image as Nanoscope export format}

\item{imageNumber}{(optional) an image number in the directory. If it is set only the selected image will be processed.}
}
\description{
A function to generate a pdf report for each \code{\link{AFMImage}} in a directory. Images should be in export Nanoscope format as the \code{\link{importFromNanoscope}} function will be used.
}
\examples{
library(AFM)
# A report will be generated for all the images in imageDirectory directory
# imageDirectory="c:/images"
imageDirectory=tempdir()
exit<-generateReportFromNanoscopeImageDirectory(imageDirectory)

# A report will be generated for the fifth image in the imageDirectory directory
exit<-generateReportFromNanoscopeImageDirectory(imageDirectory,5)
}
\author{
M.Beauvais
}
