% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onlyDeconAlgorithms.R
\name{buildSpilloverMat}
\alias{buildSpilloverMat}
\title{Build a spillover matrix}
\usage{
buildSpilloverMat(refExpr, geneExpr, method = "DCQ")
}
\arguments{
\item{refExpr}{The deconvolution matrix, e.g. LM22 or MGSM27}

\item{geneExpr}{The full gene expression for purified cell types.  Multiple columns (examples) for each column in the reference expr.}

\item{method}{One of 'DCQ', 'SVMDECON', 'DeconRNASeq', 'proportionsInAdmixture', 'nnls' (DEFAULT: DCQ)}
}
\value{
A spillover matrix showing how purified cell types deconvolve
}
\description{
Build a spillover matrix, i.e. what do purified samples deconvolve as?

spillExpr <- buildSpilloverMat(refExpr, geneExpr, method='DCQ')
}
\examples{
#This toy example 
library(ADAPTS)
fullLM22 <- ADAPTS::LM22[1:30, 1:4]
smallLM22 <- fullLM22[1:25,] 

spillover <- buildSpilloverMat(refExpr=smallLM22, geneExpr=fullLM22, method='DCQ')
}
