% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onlyDeconAlgorithms.R
\name{estCellPercent.DCQ}
\alias{estCellPercent.DCQ}
\title{DCQ Deconvolution}
\usage{
estCellPercent.DCQ(refExpr, geneExpr, marker_set = NULL,
  number_of_repeats = 10, alpha = 0.05, lambda = 0.2)
}
\arguments{
\item{refExpr}{a data frame representing immune cell expression profiles. Each row represents an expression of a gene, and each column represents a different immune cell type. colnames contains the name of each immune cell type and the rownames includes the genes' symbol. The names of each immune cell type and the symbol of each gene should be unique. Any gene with missing expression values must be excluded.}

\item{geneExpr}{a data frame representing RNA-seq or microarray gene-expression profiles of a given complex tissue. Each row represents an expression of a gene, and each column represents a different experimental sample. colnames contain the name of each sample and rownames includes the genes' symbol. The name of each individual sample and the symbol of each gene should be unique. Any gene with missing expression values should be excluded.}

\item{marker_set}{data frames of one column, that includes a preselected list of genes that likely discriminate well between the immune-cell types given in the reference data. (DEFAULT: NULL, i.e. one for each gene in the refExpr)}

\item{number_of_repeats}{using one repeat will generate only one output model. Using many repeats, DCQ calculates a collection of models, and outputs the average and standard deviation for each predicted relative cell quantity. (DEFAULT: 1)}

\item{alpha}{The elasticnet mixing parameter, with 0 <= alpha <= 1. alpha=1 is the lasso penalty, and alpha=0 the ridge penalty. (DEFAULT: 0.05)}

\item{lambda}{A minimum value for the elastic net lambda parameter (DEFAULT: 0.2)}
}
\value{
A matrix with cell type estimates for each samples
}
\description{
Use DCQ to estimate the cell count percentage
Requires installation of package 'ComICS'
  To Do: Also report the standard deviation as a confidence metric
}
\examples{
#This toy example 
library(ADAPTS)
fullLM22 <- ADAPTS::LM22[1:30, 1:4]
smallLM22 <- fullLM22[1:25,] 

cellEst <- estCellPercent.DCQ(refExpr=smallLM22, geneExpr=fullLM22)
}
