% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCLav_Lav2RAM2.R
\name{Lav2RAM2}
\alias{Lav2RAM2}
\title{Convert Lavaan Model to RAM Matrices}
\usage{
Lav2RAM2(lav_mod)
}
\arguments{
\item{lav_mod}{A named list of lavaan matrices including \code{lambda}, \code{beta}, \code{theta}, \code{psi}, and \code{alpha}.}
}
\value{
A list with components:
\describe{
\item{A}{Asymmetric path matrix (including factor loadings and structural paths)}
\item{S}{Symmetric path matrix (variances and covariances)}
\item{F}{Filter matrix mapping latent and observed variables}
\item{M}{Row vector of intercepts/means}
}
}
\description{
Converts a lavaan-style matrix list into RAM (Reticular Action Model) format,
including the A (asymmetric paths), S (symmetric paths), F (filter matrix), and M (means/intercepts) matrices.
}
\details{
This function reorganizes the lavaan-style matrices into the RAM representation,
commonly used for model standardization and transformation.
}
\keyword{internal}
