% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{v_Extract}
\alias{v_Extract}
\title{Gets information from a VIAF record}
\usage{
v_Extract(viaf, info, source = NULL)
}
\arguments{
\item{viaf}{VIAF cluster record (in JSON format).}

\item{info}{is mandatory to select which information you want to retrieve.
The options are 'titles', 'gender', 'dates', 'occupations', 'sources',
'sourceId' or 'wikipedias'.}

\item{source}{the identifier of the source (LC, WKP, JPG, BNE...)
Only if info=sourceId.}
}
\value{
depends on the info selected:
'titles' A list with titles;
'gender' The gender of the author o NULL if not exits in the record;
'dates' The bird year and death year in format byear:dyear;
'occupations' A data-frame with sources and occupations from each source or NULL if
occupations do not exist in the record;
'sources' A data-frame with text and sources;
'sourceId' A data-frame with columns text and source, or NULL if the source does
no exist in the viaf record;
'wikipedias' A vector with the URL of the Wikipedias.
}
\description{
Returns information from the VIAF record. Note that the VIAF record musts
be in JSON format.
}
