% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mab_methods.R
\name{print.mab}
\alias{print.mab}
\title{Print Generic For \code{mab}}
\usage{
\method{print}{mab}(x, ...)
}
\arguments{
\item{x}{A \code{mab} class object created by \code{\link[=single_mab_simulation]{single_mab_simulation()}}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Text summary of settings used for the Multi-Arm Bandit trial.
}
\description{
Custom Print Display for objects of \code{mab} class returned by \code{\link[=single_mab_simulation]{single_mab_simulation()}}.
Prevents the large list from being printed directly, and provides
useful information about the settings of each trial.
}
\details{
The items used to create the text summary can be found in the settings
element of the output object.

\code{...} is provided to be compatible with \code{print()}, but no other arguments
change the output.
}
\examples{
# Running a Trial
x <- single_mab_simulation(
  data = tanf,
  algorithm = "thompson",
  assignment_method = "batch",
  period_length = 1750,
  prior_periods = "All",
  blocking = FALSE,
  whole_experiment = TRUE,
  perfect_assignment = TRUE,
  data_cols = c(
    id_col = "ic_case_id",
    success_col = "success",
    condition_col = "condition"
  )
)
print(x)
}
