% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_to_posixct}
\alias{whapi_to_posixct}
\title{Convert numeric timestamp to POSIXct (UTC)}
\usage{
whapi_to_posixct(x)
}
\arguments{
\item{x}{A numeric or character vector representing a Unix timestamp
(seconds since epoch). Can be \code{NULL} or \code{NA}.}
}
\value{
A \code{POSIXct} object (in UTC) or \code{NA} if \code{x} is \code{NULL} or \code{NA}.
}
\description{
Utility function to convert a Unix timestamp (seconds since 1970-01-01 UTC)
into a \code{POSIXct} object.
Uses \code{\link[lubridate:as_date]{lubridate::as_datetime()}} for readability and consistency with the
tidyverse ecosystem.
}
\examples{
# Single timestamp
whapi_to_posixct(1756426418)

# Vector of timestamps (with NA)
whapi_to_posixct(c(1756426418, NA))

# Character input
whapi_to_posixct("1756426418")

}
\seealso{
\code{\link[lubridate:as_date]{lubridate::as_datetime()}}
}
