% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_react_to_message}
\alias{whapi_react_to_message}
\title{React to a WhatsApp message (Whapi.Cloud)}
\usage{
whapi_react_to_message(
  message_id,
  emoji,
  token = Sys.getenv("WHAPI_TOKEN", unset = ""),
  timeout = 30,
  verbose = TRUE
)
}
\arguments{
\item{message_id}{Character(1). Target message ID (WAMID).}

\item{emoji}{Character(1). Emoji to react with.
To remove a reaction, pass an empty string \code{""}.}

\item{token}{Character(1). Bearer token. Defaults to env var \code{WHAPI_TOKEN}.}

\item{timeout}{Numeric(1). Request timeout in seconds. Default: 30.}

\item{verbose}{Logical(1). Print CLI logs? Default: TRUE.}
}
\value{
A tibble with columns:
\itemize{
\item \code{id}        - message_id reacted to
\item \code{emoji}     - emoji used (or \code{""} if removed)
\item \code{status}    - \code{"ok"} if success, \code{"error"} otherwise
\item \code{success}   - logical flag from API
\item \code{resp}      - raw response (list)
}
}
\description{
Sends (or removes) an \strong{emoji reaction} to a message via
\code{PUT /messages/{MessageID}/reaction}.
The endpoint returns only \code{{ "success": true | false }}.
}
